/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.router.QueryParameters;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LocationUtil {
    private static final String PATH_SEPARATOR = "/";

    private LocationUtil() {
    }

    public static void verifyRelativePath(String path) {
        assert (path != null);
        try {
            String strippedPath = path.replaceAll("[{}*]", "");
            URI uri = new URI(URLEncoder.encode(strippedPath, StandardCharsets.UTF_8.name()));
            if (uri.isAbsolute()) {
                throw new InvalidLocationException("Relative path cannot contain an URI scheme");
            }
            if (uri.getPath().startsWith(PATH_SEPARATOR)) {
                throw new InvalidLocationException("Relative path cannot start with /");
            }
            if (LocationUtil.hasIncorrectParentSegments(uri.getRawPath())) {
                throw new InvalidLocationException("Relative path cannot contain .. segments");
            }
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new InvalidLocationException("Cannot parse path: " + path, e);
        }
    }

    public static List<String> parsePathToSegments(String path) {
        int endIndex = path.indexOf("?");
        String basePath = endIndex >= 0 ? path.substring(0, endIndex) : (path.contains("#") ? path.substring(0, path.indexOf(35)) : path);
        LocationUtil.verifyRelativePath(basePath);
        List<String> splitList = Arrays.asList(basePath.split(PATH_SEPARATOR));
        if (basePath.endsWith(PATH_SEPARATOR)) {
            ArrayList<String> result = new ArrayList<String>(splitList.size() + 1);
            result.addAll(splitList);
            result.add("");
            return result;
        }
        return splitList;
    }

    public static String ensureRelativeNonNull(String location) {
        if (location == null) {
            return "";
        }
        if (location.startsWith(PATH_SEPARATOR)) {
            location = location.substring(1);
        }
        return location.trim();
    }

    public static QueryParameters parseQueryParameters(String location) {
        String query;
        if (location == null) {
            return QueryParameters.empty();
        }
        int beginIndex = location.indexOf("?");
        if (beginIndex < 0) {
            return QueryParameters.empty();
        }
        try {
            query = new URI(location).getQuery();
        }
        catch (URISyntaxException ignore) {
            query = null;
        }
        if (query == null) {
            query = location.substring(beginIndex + 1);
        }
        return QueryParameters.fromString(query);
    }

    private static boolean hasIncorrectParentSegments(String path) {
        if (path.startsWith("..%2F")) {
            return true;
        }
        if (path.contains("%2F..%2F")) {
            return true;
        }
        if (path.endsWith("%2F..")) {
            return true;
        }
        return path.equals("..");
    }
}

