/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadImpl;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import org.slf4j.LoggerFactory;

public class BrowserLiveReloadAccess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowserLiveReload getLiveReload(VaadinService service) {
        BrowserLiveReloadImpl liveReload;
        if (service.getDeploymentConfiguration().isProductionMode()) {
            LoggerFactory.getLogger(BrowserLiveReloadAccess.class).debug("BrowserLiveReloadAccess::getLiveReload is called in production mode.");
            return null;
        }
        if (!service.getDeploymentConfiguration().isDevModeLiveReloadEnabled()) {
            LoggerFactory.getLogger(BrowserLiveReloadAccess.class).debug("BrowserLiveReloadAccess::getLiveReload is called when live reload is disabled.");
            return null;
        }
        VaadinContext context = service.getContext();
        BrowserLiveReloadAccess browserLiveReloadAccess = this;
        synchronized (browserLiveReloadAccess) {
            liveReload = context.getAttribute(BrowserLiveReloadImpl.class);
            if (liveReload == null) {
                liveReload = new BrowserLiveReloadImpl();
                context.setAttribute(BrowserLiveReloadImpl.class, liveReload);
            }
        }
        return liveReload;
    }
}

