/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.internal.DeadlockDetectingCompletableFuture;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonValue;
import java.util.concurrent.CompletableFuture;

public interface PendingJavaScriptResult
extends Page.ExecutionCanceler {
    @Override
    public boolean cancelExecution();

    public boolean isSentToBrowser();

    default public <T> void then(Class<T> targetType, SerializableConsumer<T> resultHandler, SerializableConsumer<String> errorHandler) {
        if (targetType == null) {
            throw new IllegalArgumentException("Target type cannot be null");
        }
        if (resultHandler == null) {
            throw new IllegalArgumentException("Result handler cannot be null");
        }
        SerializableConsumer convertingResultHandler = value -> resultHandler.accept(JsonCodec.decodeAs(value, targetType));
        this.then(convertingResultHandler, errorHandler);
    }

    default public <T> void then(Class<T> targetType, SerializableConsumer<T> resultHandler) {
        this.then(targetType, resultHandler, null);
    }

    default public <T> CompletableFuture<T> toCompletableFuture(Class<T> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("Target type cannot be null");
        }
        VaadinSession session = VaadinSession.getCurrent();
        DeadlockDetectingCompletableFuture completableFuture = new DeadlockDetectingCompletableFuture(session);
        this.then(value -> {
            Object convertedValue = JsonCodec.decodeAs(value, targetType);
            completableFuture.complete(convertedValue);
        }, errorValue -> {
            JavaScriptException exception = new JavaScriptException((String)errorValue);
            completableFuture.completeExceptionally(exception);
        });
        return completableFuture;
    }

    public void then(SerializableConsumer<JsonValue> var1, SerializableConsumer<String> var2);

    default public void then(SerializableConsumer<JsonValue> resultHandler) {
        this.then(resultHandler, null);
    }

    default public CompletableFuture<JsonValue> toCompletableFuture() {
        return this.toCompletableFuture(JsonValue.class);
    }

    public static class JavaScriptException
    extends RuntimeException {
        public JavaScriptException(String message) {
            super(message);
        }
    }
}

