/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeList;
import com.vaadin.flow.internal.nodefeature.SerializableNodeList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SynchronizedPropertiesList
extends SerializableNodeList<String> {
    private Map<String, DisabledUpdateMode> disabledRpcModes;

    public SynchronizedPropertiesList(StateNode node) {
        super(node);
    }

    public Set<String> getSynchronizedProperties() {
        return new PropertiesSetView(this);
    }

    public void add(String property, DisabledUpdateMode mode) {
        Objects.requireNonNull(mode, "The argument which controls RPC for disabled element may not be null");
        this.getSynchronizedProperties().add(property);
        if (!DisabledUpdateMode.ONLY_WHEN_ENABLED.equals((Object)mode)) {
            if (this.disabledRpcModes == null) {
                this.disabledRpcModes = new HashMap<String, DisabledUpdateMode>();
            }
            this.disabledRpcModes.put(property, mode);
        }
    }

    public DisabledUpdateMode getDisabledUpdateMode(String property) {
        DisabledUpdateMode mode;
        DisabledUpdateMode disabledUpdateMode = mode = this.disabledRpcModes == null ? null : this.disabledRpcModes.get(property);
        if (mode == null) {
            return DisabledUpdateMode.ONLY_WHEN_ENABLED;
        }
        return mode;
    }

    private static class PropertiesSetView
    extends NodeList.SetView<String> {
        private SynchronizedPropertiesList origin;

        private PropertiesSetView(SynchronizedPropertiesList list) {
            super(list);
            this.origin = list;
        }

        @Override
        protected void validate(String item) {
            if (item == null) {
                throw new IllegalArgumentException("Property name cannot be null");
            }
        }

        @Override
        public boolean remove(Object item) {
            if (this.origin.disabledRpcModes != null) {
                this.origin.disabledRpcModes.remove(item);
            }
            return super.remove(item);
        }
    }
}

