/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.migration;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.stream.Stream;

public abstract class ClassPathIntrospector
implements Serializable {
    private final ClassFinder finder;

    protected ClassPathIntrospector(ClassFinder finder) {
        this.finder = finder;
    }

    public ClassPathIntrospector(ClassPathIntrospector otherIntrospector) {
        this.finder = otherIntrospector.finder;
    }

    protected URL getResource(String name) {
        return this.finder.getResource(name);
    }

    protected Stream<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotationInProjectContext) {
        return this.finder.getAnnotatedClasses(annotationInProjectContext).stream();
    }

    protected Stream<Class<?>> getSubtypes(Class<?> type) {
        return this.finder.getSubTypesOf(this.loadClassInProjectClassLoader(type.getName())).stream();
    }

    public <T> Class<T> loadClassInProjectClassLoader(String className) {
        try {
            return this.finder.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Failed to load class '%s' in custom classloader", className), e);
        }
    }

    protected <T> T invokeAnnotationMethod(Annotation target, String methodName) {
        return (T)this.doInvokeAnnotationMethod(target, methodName);
    }

    protected Object doInvokeAnnotationMethod(Annotation target, String methodName) {
        try {
            return target.getClass().getDeclaredMethod(methodName, new Class[0]).invoke((Object)target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(String.format("Failed to access method '%s' in annotation interface '%s', should not be happening due to JLS definition of annotation interface", methodName, target), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Got an exception by invoking method '%s' from annotation '%s'", methodName, target), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Annotation '%s' has no method named `%s", target, methodName), e);
        }
    }
}

