/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.common.ArtifactData;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.plugin.production.ProductionModeCopyStep;
import com.vaadin.flow.server.frontend.JarContentsManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="copy-production-files", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class CopyProductionFilesMojo
extends FlowModeAbstractMojo {
    private static final String ADD_ON_FRONTEND = "src/main/resources/META-INF/frontend";
    @Parameter(name="copyOutputDirectory", defaultValue="${project.build.directory}/frontend/", required=true)
    private File copyOutputDirectory;
    @Parameter(name="excludes", defaultValue="**/LICENSE*,**/LICENCE*,**/demo/**,**/docs/**,**/test*/**,**/.*,**/*.md,**/bower.json,**/package.json,**/package-lock.json", required=true)
    private String excludes;
    @Parameter(name="frontendWorkingDirectory", property="frontend.working.directory")
    private File frontendWorkingDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (!this.compatibility) {
            this.getLog().info((CharSequence)"Skipped `copy-production-files` goal because compatibility mode is not set.");
            return;
        }
        List<ArtifactData> projectArtifacts = this.project.getArtifacts().stream().filter(artifact -> "jar".equals(artifact.getType())).map(artifact -> new ArtifactData(artifact.getFile(), artifact.getArtifactId(), artifact.getVersion())).collect(Collectors.toList());
        if (this.frontendWorkingDirectory == null) {
            List<String> potentialFrontEndDirectories = Arrays.asList("src/main/webapp/frontend", ADD_ON_FRONTEND, "src/main/resources/META-INF/resources/frontend", "src/main/resources/public/frontend", "src/main/resources/static/frontend", "src/main/resources/resources/frontend");
            for (String dir : potentialFrontEndDirectories) {
                File directory = new File(this.project.getBasedir(), dir);
                if (!directory.exists()) continue;
                this.frontendWorkingDirectory = directory;
                break;
            }
        }
        new ProductionModeCopyStep(new JarContentsManager(), projectArtifacts).copyWebApplicationFiles(this.copyOutputDirectory, this.frontendWorkingDirectory, this.excludes);
    }

    @Override
    boolean isDefaultCompatibility() {
        return true;
    }
}

