/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.AnchorTarget;
import com.vaadin.flow.component.html.AnchorTargetValue;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

@Tag(value="a")
public class Anchor
extends HtmlContainer
implements Focusable<Anchor>,
HasAriaLabel {
    private static final PropertyDescriptor<String, String> hrefDescriptor = PropertyDescriptors.attributeWithDefault((String)"href", (String)"", (boolean)false);
    private static final PropertyDescriptor<String, Optional<String>> targetDescriptor = PropertyDescriptors.optionalAttributeWithDefault((String)"target", (String)AnchorTarget.DEFAULT.getValue());
    private static final String ROUTER_IGNORE_ATTRIBUTE = "router-ignore";
    private Serializable href;

    public Anchor() {
    }

    public Anchor(String href, String text) {
        this.setHref(href);
        this.setText(text);
    }

    public Anchor(String href, String text, AnchorTarget target) {
        this.setHref(href);
        this.setText(text);
        this.setTarget(target);
    }

    public Anchor(AbstractStreamResource href, String text) {
        this.setHref(href);
        this.setText(text);
    }

    public Anchor(String href, Component ... components) {
        this.setHref(href);
        this.add(components);
    }

    public void setHref(String href) {
        if (href == null) {
            throw new IllegalArgumentException("Href must not be null");
        }
        this.href = href;
        this.assignHrefAttribute();
    }

    public void removeHref() {
        this.getElement().removeAttribute("href");
        this.href = null;
    }

    public void setHref(AbstractStreamResource href) {
        this.href = href;
        this.getElement().setAttribute(ROUTER_IGNORE_ATTRIBUTE, true);
        this.assignHrefAttribute();
    }

    public String getHref() {
        if (this.href instanceof String) {
            return (String)((Object)this.href);
        }
        if (this.href instanceof AbstractStreamResource) {
            return StreamResourceRegistry.getURI((AbstractStreamResource)((AbstractStreamResource)this.href)).toString();
        }
        return (String)this.get(hrefDescriptor);
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.assignHrefAttribute();
    }

    private void assignHrefAttribute() {
        if (this.isEnabled()) {
            if (this.href != null) {
                if (this.href instanceof AbstractStreamResource) {
                    this.getElement().setAttribute("href", (AbstractStreamResource)this.href);
                } else {
                    this.set(hrefDescriptor, (String)((Object)this.href));
                }
            }
        } else {
            this.getElement().removeAttribute("href");
        }
    }

    public void setTarget(String target) {
        this.set(targetDescriptor, target);
    }

    public Optional<String> getTarget() {
        return (Optional)this.get(targetDescriptor);
    }

    public void setTarget(AnchorTargetValue target) {
        Objects.requireNonNull(target, "target cannot be null.");
        this.setTarget(target.getValue());
    }

    public AnchorTargetValue getTargetValue() {
        Optional<String> target = this.getTarget();
        if (target.isPresent()) {
            return AnchorTargetValue.forString(target.get());
        }
        return AnchorTarget.DEFAULT;
    }
}

