/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dnd;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dnd.DropEffect;
import com.vaadin.flow.component.dnd.DropEvent;
import com.vaadin.flow.component.dnd.internal.DndUtil;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.util.Locale;
import java.util.Objects;

@JsModule(value="./dndConnector-es6.js")
public interface DropTarget<T extends Component>
extends HasElement {
    public static <T extends Component> DropTarget<T> create(T component) {
        return DropTarget.configure(component, true);
    }

    public static <T extends Component> DropTarget<T> configure(final T component) {
        return new DropTarget<T>(){

            @Override
            public T getDropTargetComponent() {
                return component;
            }
        };
    }

    public static <T extends Component> DropTarget<T> configure(T component, boolean active) {
        DropTarget<T> dropTarget = DropTarget.configure(component);
        dropTarget.setActive(active);
        return dropTarget;
    }

    default public T getDropTargetComponent() {
        return (T)((Component)this);
    }

    default public Element getElement() {
        return this.getDropTargetComponent().getElement();
    }

    default public void setActive(boolean active) {
        if (this.isActive() != active) {
            this.getElement().setProperty("__active", active);
            DndUtil.updateDropTargetActivation(this);
            DndUtil.addMobileDndPolyfillIfNeeded(this.getDropTargetComponent());
            DndUtil.reportUsage();
        }
    }

    default public boolean isActive() {
        return this.getElement().getProperty("__active", false);
    }

    default public void setDropEffect(DropEffect dropEffect) {
        if (!Objects.equals((Object)this.getDropEffect(), (Object)dropEffect)) {
            if (dropEffect == null) {
                this.getElement().removeProperty("__dropEffect");
            } else {
                this.getElement().setProperty("__dropEffect", dropEffect.toString().toLowerCase(Locale.ENGLISH));
            }
        }
    }

    default public DropEffect getDropEffect() {
        String dropEffect = this.getElement().getProperty("__dropEffect", null);
        return dropEffect == null ? null : DropEffect.fromString(dropEffect);
    }

    default public Registration addDropListener(ComponentEventListener<DropEvent<T>> listener) {
        return ComponentUtil.addListener(this.getDropTargetComponent(), DropEvent.class, listener);
    }
}

