/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.dom.Element;
import java.util.Optional;
import java.util.stream.IntStream;

public interface HasItemComponents<T>
extends HasComponents {
    default public void addComponents(T afterItem, Component ... components) {
        int insertPosition = this.getItemPosition(afterItem);
        if (insertPosition == -1) {
            throw new IllegalArgumentException("Could not locate the item after which to insert components.");
        }
        for (Component component : components) {
            this.getElement().insertChild(++insertPosition, new Element[]{component.getElement()});
        }
    }

    default public void prependComponents(T beforeItem, Component ... components) {
        int insertPosition = this.getItemPosition(beforeItem);
        if (insertPosition == -1) {
            throw new IllegalArgumentException("Could not locate the item before which to insert components.");
        }
        for (Component component : components) {
            this.getElement().insertChild(insertPosition, new Element[]{component.getElement()});
            ++insertPosition;
        }
    }

    default public int getItemPosition(T item) {
        if (item == null) {
            return -1;
        }
        return IntStream.range(0, this.getElement().getChildCount()).filter(i -> {
            Optional c = this.getElement().getChild(i).getComponent();
            return c.isPresent() && c.get() instanceof ItemComponent && item.equals(((ItemComponent)c.get()).getItem());
        }).findFirst().orElse(-1);
    }

    public static interface ItemComponent<T>
    extends HasElement {
        public T getItem();
    }
}

