/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import com.vaadin.copilot.AICommandHandler;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.OpenComponentInIDE;
import com.vaadin.copilot.ProjectFileHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.UserInfoHandler;
import com.vaadin.copilot.analytics.AnalyticsClient;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class Copilot
implements DevToolsMessageHandler {
    static final String PREFIX = "copilot-";
    static final String VALUE = "value";
    ProjectManager projectManager;
    private List<CopilotCommand> commands;
    private AnalyticsClient analyticsClient;

    public void handleConnect(DevToolsInterface devToolsInterface) {
        try {
            ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)VaadinService.getCurrent().getContext());
            Path projectRoot = applicationConfiguration.getProjectFolder().toPath();
            this.projectManager = new ProjectManager(projectRoot);
            if (System.getProperty("copilot.development") == null && this.isUsageStatisticsEnabled()) {
                this.analyticsClient = new AnalyticsClient();
            }
            this.setupCommands(devToolsInterface, applicationConfiguration);
            devToolsInterface.send("copilot-init", null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create project manager", e);
        }
    }

    private void setupCommands(DevToolsInterface devToolsInterface, ApplicationConfiguration applicationConfiguration) {
        this.commands = List.of(new OpenComponentInIDE(applicationConfiguration), new ProjectFileHandler(this.projectManager), new AICommandHandler(this.projectManager), new UserInfoHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (!command.startsWith(PREFIX)) {
            return false;
        }
        if (command.equals("copilot-track-event")) {
            String event = PREFIX + data.getString("event");
            if (data.hasKey(VALUE)) {
                this.track(event, Map.of(VALUE, data.getString(VALUE)));
            } else {
                this.track(event, null);
            }
            return true;
        }
        try {
            command = command.substring(PREFIX.length());
            for (CopilotCommand copilotCommand : this.commands) {
                if (!copilotCommand.handleMessage(command, data, devToolsInterface)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.track("copilot-command-" + command, null);
        }
        return false;
    }

    private void track(String event, Map<String, String> properties) {
        if (this.analyticsClient != null) {
            this.analyticsClient.track(event, properties);
        }
    }

    private boolean isUsageStatisticsEnabled() {
        return ApplicationConfiguration.get((VaadinContext)VaadinService.getCurrent().getContext()).isUsageStatisticsEnabled();
    }
}

