/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.collaborationengine.Backend;
import com.vaadin.collaborationengine.BackendUtil;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.EntryList;
import com.vaadin.collaborationengine.EventUtil;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.ListChange;
import com.vaadin.collaborationengine.ListChangeType;
import com.vaadin.collaborationengine.MapChange;
import com.vaadin.collaborationengine.MapChangeType;
import com.vaadin.collaborationengine.MembershipEvent;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Topic {
    private final String id;
    private final CollaborationEngine collaborationEngine;
    private final Map<String, Map<String, Entry>> namedMapData = new HashMap<String, Map<String, Entry>>();
    private final Map<String, EntryList> namedListData = new HashMap<String, EntryList>();
    final Map<String, Duration> mapExpirationTimeouts = new HashMap<String, Duration>();
    final Map<String, Duration> listExpirationTimeouts = new HashMap<String, Duration>();
    private final List<UUID> activeNodes = new ArrayList<UUID>();
    private Instant lastDisconnected;
    private final List<SerializableBiConsumer<UUID, ChangeDetails>> changeListeners = new ArrayList<SerializableBiConsumer<UUID, ChangeDetails>>();
    private final Map<UUID, SerializableConsumer<ChangeResult>> changeResultTrackers = new ConcurrentHashMap<UUID, SerializableConsumer<ChangeResult>>();
    private final List<UUID> backendNodes = new ArrayList<UUID>();
    private final Backend.EventLog eventLog;
    private UUID lastSnapshotId;
    private boolean leader;
    private int changeCount;

    Topic(String id, CollaborationEngine collaborationEngine, Backend.EventLog eventLog) {
        this.id = id;
        this.collaborationEngine = collaborationEngine;
        this.eventLog = eventLog;
        Backend backend = this.getBackend();
        backend.addMembershipListener(event -> {
            if (event.getType().equals((Object)MembershipEvent.MembershipEventType.LEAVE)) {
                this.handleNodeLeave(event.getNodeId());
            }
        });
        if (eventLog != null) {
            BackendUtil.initializeFromSnapshot(collaborationEngine, this::initializeFromSnapshot).thenAccept(uuid -> {
                this.lastSnapshotId = uuid;
            });
        }
    }

    UUID getCurrentNodeId() {
        return this.getBackend().getNodeId();
    }

    private Backend getBackend() {
        return this.collaborationEngine.getConfiguration().getBackend();
    }

    private CompletableFuture<UUID> initializeFromSnapshot() {
        return this.getBackend().loadLatestSnapshot(this.id).thenCompose(this::loadAndSubscribe);
    }

    private CompletableFuture<UUID> loadAndSubscribe(Backend.Snapshot snapshot) {
        CompletableFuture<UUID> future = new CompletableFuture<UUID>();
        try {
            UUID latestChange = null;
            if (snapshot != null) {
                ObjectNode payload = JsonUtil.fromString(snapshot.getPayload());
                latestChange = JsonUtil.toUUID(payload.get("latest"));
                this.loadSnapshot(new Snapshot(payload));
                this.eventLog.subscribe(latestChange, this::applyChange);
            } else {
                this.eventLog.subscribe(null, this::applyChange);
            }
            ObjectNode nodeEvent = JsonUtil.createNodeJoin(this.getCurrentNodeId());
            this.eventLog.submitEvent(UUID.randomUUID(), JsonUtil.toString(nodeEvent));
            future.complete(latestChange);
        }
        catch (Backend.EventIdNotFoundException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    synchronized void handleNodeLeave(UUID nodeId) {
        Backend backend = this.collaborationEngine.getConfiguration().getBackend();
        this.backendNodes.remove(nodeId);
        if (!this.backendNodes.isEmpty() && this.backendNodes.get(0).equals(backend.getNodeId())) {
            this.becomeLeader();
        }
        if (this.leader) {
            this.cleanupStaleEntries(nodeId::equals);
        }
    }

    private void cleanupStaleEntries(Predicate<UUID> isStale) {
        this.namedMapData.entrySet().stream().flatMap(map -> ((Map)map.getValue()).entrySet().stream().filter(entry -> isStale.test(((Entry)entry.getValue()).scopeOwnerId)).map(entry -> {
            ObjectNode change = JsonUtil.createPutChange((String)map.getKey(), (String)entry.getKey(), null, null, null);
            change.put("expected-id", ((Entry)entry.getValue()).revisionId.toString());
            return change;
        })).collect(Collectors.toList()).forEach(change -> this.eventLog.submitEvent(UUID.randomUUID(), JsonUtil.toString(change)));
        this.namedListData.entrySet().stream().flatMap(list -> ((EntryList)list.getValue()).stream().filter(entry -> isStale.test(entry.scopeOwnerId)).map(entry -> {
            ObjectNode change = JsonUtil.createListSetChange((String)list.getKey(), entry.id.toString(), null, null);
            change.put("expected-id", entry.revisionId.toString());
            return change;
        })).collect(Collectors.toList()).forEach(change -> this.eventLog.submitEvent(UUID.randomUUID(), JsonUtil.toString(change)));
    }

    Registration subscribeToChange(SerializableBiConsumer<UUID, ChangeDetails> changeListener) {
        this.clearExpiredData();
        this.changeListeners.add(changeListener);
        return (Registration & Serializable)() -> this.changeListeners.remove(changeListener);
    }

    private void clearExpiredData() {
        Clock clock = this.collaborationEngine.getClock();
        if (this.isLeader() && this.lastDisconnected != null) {
            Instant now = clock.instant();
            this.mapExpirationTimeouts.entrySet().stream().filter(entry -> now.isAfter(this.lastDisconnected.plus((TemporalAmount)entry.getValue())) && this.namedMapData.containsKey(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(name -> {
                this.namedMapData.get(name).entrySet().stream().map(entry -> {
                    ObjectNode change = JsonUtil.createPutChange(name, (String)entry.getKey(), null, null, null);
                    change.put("expected-id", ((Entry)entry.getValue()).revisionId.toString());
                    return change;
                }).collect(Collectors.toList()).forEach(change -> this.eventLog.submitEvent(UUID.randomUUID(), JsonUtil.toString(change)));
                this.mapExpirationTimeouts.remove(name);
            });
            this.listExpirationTimeouts.entrySet().stream().filter(entry -> now.isAfter(this.lastDisconnected.plus((TemporalAmount)entry.getValue())) && this.namedListData.containsKey(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(name -> {
                this.namedListData.get(name).stream().map(entry -> {
                    ObjectNode change = JsonUtil.createListSetChange(name, entry.id.toString(), null, null);
                    change.put("expected-id", entry.revisionId.toString());
                    return change;
                }).collect(Collectors.toList()).forEach(change -> this.eventLog.submitEvent(UUID.randomUUID(), JsonUtil.toString(change)));
                this.listExpirationTimeouts.remove(name);
            });
        }
    }

    Stream<MapChange> getMapData(String mapName) {
        Map<String, Entry> mapData = this.namedMapData.get(mapName);
        if (mapData == null) {
            return Stream.empty();
        }
        return mapData.entrySet().stream().map(entry -> new MapChange(mapName, MapChangeType.PUT, (String)entry.getKey(), null, ((Entry)entry.getValue()).data, null, ((Entry)entry.getValue()).revisionId));
    }

    JsonNode getMapValue(String mapName, String key) {
        Map<String, Entry> map = this.namedMapData.get(mapName);
        if (map == null || !map.containsKey(key)) {
            return null;
        }
        return map.get((Object)key).data.deepCopy();
    }

    synchronized ChangeResult applyChange(UUID trackingId, String payload) {
        String snapshot;
        UUID newId;
        ChangeDetails details;
        String type;
        ObjectNode change = JsonUtil.fromString(payload);
        ++this.changeCount;
        switch (type = change.get("type").asText()) {
            case "m-put": {
                details = this.applyMapPut(trackingId, change);
                break;
            }
            case "m-replace": {
                details = this.applyMapReplace(trackingId, change);
                break;
            }
            case "l-insert": {
                details = this.applyListInsert(trackingId, change);
                break;
            }
            case "l-move-before": {
                details = this.applyListMoveBefore(trackingId, change);
                break;
            }
            case "l-move-after": {
                details = this.applyListMoveAfter(trackingId, change);
                break;
            }
            case "l-set": {
                details = this.applyListSet(trackingId, change);
                break;
            }
            case "m-timeout": {
                this.applyMapTimeout(change);
                return ChangeResult.ACCEPTED;
            }
            case "l-timeout": {
                this.applyListTimeout(change);
                return ChangeResult.ACCEPTED;
            }
            case "node-activate": {
                UUID nodeId = UUID.fromString(change.get("node-id").asText());
                this.activeNodes.add(nodeId);
                this.lastDisconnected = null;
                return ChangeResult.ACCEPTED;
            }
            case "node-deactivate": {
                UUID nodeId = UUID.fromString(change.get("node-id").asText());
                this.activeNodes.remove(nodeId);
                if (this.activeNodes.isEmpty()) {
                    this.lastDisconnected = this.collaborationEngine.getClock().instant();
                }
                return ChangeResult.ACCEPTED;
            }
            case "node-join": {
                UUID nodeId = UUID.fromString(change.get("node-id").asText());
                if (this.backendNodes.isEmpty() && this.collaborationEngine.getConfiguration().getBackend().getNodeId().equals(nodeId)) {
                    this.becomeLeader();
                }
                this.backendNodes.add(nodeId);
                return ChangeResult.ACCEPTED;
            }
            default: {
                throw new UnsupportedOperationException("Type '" + type + "' is not a supported change type");
            }
        }
        ChangeResult result = details != null ? ChangeResult.ACCEPTED : ChangeResult.REJECTED;
        SerializableConsumer<ChangeResult> changeResultTracker = this.changeResultTrackers.remove(trackingId);
        if (changeResultTracker != null) {
            changeResultTracker.accept((Object)result);
        }
        if (ChangeResult.ACCEPTED.equals((Object)result)) {
            EventUtil.fireEvents(this.changeListeners, listener -> listener.accept((Object)trackingId, (Object)details), true);
        }
        if (this.lastSnapshotId == null) {
            newId = UUID.randomUUID();
            snapshot = JsonUtil.toString(Snapshot.fromTopic(this, trackingId).toObjectNode());
            this.getBackend().replaceSnapshot(this.id, null, newId, snapshot);
            this.getBackend().loadLatestSnapshot(this.id).thenAccept(s -> {
                this.lastSnapshotId = s.getId();
            });
        }
        if (this.leader && this.changeCount % 100 == 0) {
            newId = UUID.randomUUID();
            snapshot = Snapshot.fromTopic(this, trackingId).toObjectNode();
            this.getBackend().replaceSnapshot(this.id, this.lastSnapshotId, newId, JsonUtil.toString(snapshot)).thenAccept(s -> this.eventLog.truncate(this.lastSnapshotId));
            this.lastSnapshotId = newId;
        }
        return result;
    }

    void loadSnapshot(Snapshot snapshot) {
        if (!(this.namedListData.isEmpty() && this.namedMapData.isEmpty() && this.backendNodes.isEmpty())) {
            throw new IllegalStateException("You can only load snapshots for empty topics");
        }
        this.namedListData.putAll(snapshot.getLists());
        this.namedMapData.putAll(snapshot.getMaps());
        this.listExpirationTimeouts.putAll(snapshot.getListTimeouts());
        this.mapExpirationTimeouts.putAll(snapshot.getMapTimeouts());
        this.activeNodes.addAll(snapshot.getActiveNodes());
        this.backendNodes.addAll(snapshot.getBackendNodes());
    }

    private void becomeLeader() {
        this.leader = true;
        HashSet<UUID> backendNodesCopy = new HashSet<UUID>(this.backendNodes);
        this.cleanupStaleEntries(id -> !backendNodesCopy.contains(id));
    }

    boolean isLeader() {
        return this.leader;
    }

    ChangeDetails applyMapPut(UUID changeId, ObjectNode change) {
        UUID oldChangeId;
        String mapName = change.get("name").asText();
        String key = change.get("key").asText();
        JsonNode expectedValue = change.get("expected-value");
        JsonNode expectedId = change.get("expected-id");
        JsonNode newValue = change.get("value");
        Map map = this.namedMapData.computeIfAbsent(mapName, name -> new HashMap());
        NullNode oldValue = map.containsKey(key) ? ((Entry)map.get((Object)key)).data : NullNode.getInstance();
        UUID uUID = oldChangeId = map.containsKey(key) ? ((Entry)map.get((Object)key)).revisionId : null;
        if (expectedId != null && !Objects.equals(oldChangeId, JsonUtil.toUUID(expectedId))) {
            return null;
        }
        if (expectedValue != null && !Objects.equals(oldValue, expectedValue)) {
            return null;
        }
        if (newValue instanceof NullNode) {
            map.remove(key);
        } else {
            map.put(key, new Entry(changeId, newValue.deepCopy(), JsonUtil.toUUID(change.get("scope-owner"))));
        }
        return new MapChange(mapName, MapChangeType.PUT, key, (JsonNode)oldValue, newValue, JsonUtil.toUUID(expectedId), changeId);
    }

    ChangeDetails applyMapReplace(UUID changeId, ObjectNode change) {
        NullNode oldValue;
        String mapName = change.get("name").asText();
        String key = change.get("key").asText();
        JsonNode expectedValue = change.get("expected-value");
        JsonNode newValue = change.get("value");
        Map map = this.namedMapData.computeIfAbsent(mapName, name -> new HashMap());
        Object object = oldValue = map.containsKey(key) ? ((Entry)map.get((Object)key)).data : NullNode.getInstance();
        if (expectedValue != null && !Objects.equals(oldValue, expectedValue)) {
            return null;
        }
        if (newValue instanceof NullNode) {
            map.remove(key);
        } else {
            map.put(key, new Entry(changeId, newValue.deepCopy(), JsonUtil.toUUID(change.get("scope-owner"))));
        }
        return new MapChange(mapName, MapChangeType.REPLACE, key, (JsonNode)oldValue, newValue, null, changeId);
    }

    ChangeDetails applyListInsert(UUID id, ObjectNode change) {
        EntryList.ListEntrySnapshot insertedEntry;
        String listName = change.get("name").asText();
        UUID key = JsonUtil.toUUID(change.get("key"));
        JsonNode item = change.get("item");
        UUID scopeOwnerId = JsonUtil.toUUID(change.get("scope-owner"));
        boolean before = change.get("before").asBoolean();
        EntryList list = this.getOrCreateList(listName);
        if (change.has("empty")) {
            boolean empty = change.get("empty").asBoolean();
            if (empty && list.size() > 0) {
                return null;
            }
            if (!empty && list.size() == 0) {
                return null;
            }
        }
        for (JsonNode condition : change.withArray("conditions")) {
            UUID leftKey = JsonUtil.toUUID(condition.get("key"));
            UUID rightKey = JsonUtil.toUUID(condition.get("other-key"));
            if (leftKey == null && this.getListEntry((String)listName, (UUID)rightKey).prev != null) {
                return null;
            }
            if (leftKey == null || Objects.equals(this.getListEntry((String)listName, (UUID)leftKey).next, rightKey)) continue;
            return null;
        }
        if (key == null) {
            insertedEntry = before ? list.insertLast(id, item, id, scopeOwnerId) : list.insertFirst(id, item, id, scopeOwnerId);
        } else {
            EntryList.ListEntrySnapshot entry = list.getEntry(key);
            if (entry == null) {
                return null;
            }
            insertedEntry = before ? list.insertBefore(key, id, item, id, scopeOwnerId) : list.insertAfter(key, id, item, id, scopeOwnerId);
        }
        return new ListChange(listName, ListChangeType.INSERT, id, null, item, null, insertedEntry.prev, null, insertedEntry.next, null, id);
    }

    ChangeDetails applyListMoveBefore(UUID trackingId, ObjectNode change) {
        String listName = change.get("name").asText();
        UUID keyToFind = JsonUtil.toUUID(change.get("key"));
        UUID keyToMove = JsonUtil.toUUID(change.get("other-key"));
        EntryList list = this.getOrCreateList(listName);
        EntryList.ListEntrySnapshot entryToFind = list.getEntry(keyToFind);
        if (entryToFind == null) {
            return null;
        }
        EntryList.ListEntrySnapshot entryToMove = list.getEntry(keyToMove);
        if (entryToMove == null) {
            return null;
        }
        list.moveBefore(keyToFind, keyToMove, trackingId);
        return new ListChange(listName, ListChangeType.MOVE, keyToMove, entryToMove.value, entryToMove.value, entryToMove.prev, entryToFind.prev, entryToMove.next, keyToFind, null, trackingId);
    }

    ChangeDetails applyListMoveAfter(UUID trackingId, ObjectNode change) {
        String listName = change.get("name").asText();
        UUID keyToFind = JsonUtil.toUUID(change.get("key"));
        UUID keyToMove = JsonUtil.toUUID(change.get("other-key"));
        EntryList list = this.getOrCreateList(listName);
        EntryList.ListEntrySnapshot entryToFind = list.getEntry(keyToFind);
        if (entryToFind == null) {
            return null;
        }
        EntryList.ListEntrySnapshot entryToMove = list.getEntry(keyToMove);
        if (entryToMove == null) {
            return null;
        }
        list.moveAfter(keyToFind, keyToMove, trackingId);
        return new ListChange(listName, ListChangeType.MOVE, keyToMove, entryToMove.value, entryToMove.value, entryToMove.prev, keyToFind, entryToMove.next, entryToFind.next, null, trackingId);
    }

    private ChangeDetails applyListSet(UUID trackingId, ObjectNode change) {
        String listName = change.get("name").asText();
        UUID key = JsonUtil.toUUID(change.get("key"));
        JsonNode newValue = change.get("value");
        UUID expectedId = JsonUtil.toUUID(change.get("expected-id"));
        EntryList list = this.getOrCreateList(listName);
        EntryList.ListEntrySnapshot entry = list.getEntry(key);
        if (entry == null) {
            return null;
        }
        if (expectedId != null && !Objects.equals(entry.revisionId, expectedId)) {
            return null;
        }
        if (newValue.isNull()) {
            list.remove(key);
            return new ListChange(listName, ListChangeType.SET, key, entry.value, null, entry.prev, null, entry.next, null, expectedId, null);
        }
        JsonNode oldValue = entry.value;
        UUID scopeOwnerId = JsonUtil.toUUID(change.get("scope-owner"));
        list.setValue(key, newValue, trackingId, scopeOwnerId);
        return new ListChange(listName, ListChangeType.SET, key, oldValue, newValue, entry.prev, entry.prev, entry.next, entry.next, expectedId, trackingId);
    }

    void applyMapTimeout(ObjectNode change) {
        String mapName = change.get("name").asText();
        JsonNode newValue = change.get("value");
        if (newValue instanceof NullNode) {
            this.mapExpirationTimeouts.remove(mapName);
        } else {
            Duration timeout = JsonUtil.toInstance(newValue, Duration.class);
            this.mapExpirationTimeouts.put(mapName, timeout);
        }
    }

    void applyListTimeout(ObjectNode change) {
        String listName = change.get("name").asText();
        JsonNode newValue = change.get("value");
        if (newValue instanceof NullNode) {
            this.listExpirationTimeouts.remove(listName);
        } else {
            Duration timeout = JsonUtil.toInstance(newValue, Duration.class);
            this.listExpirationTimeouts.put(listName, timeout);
        }
    }

    Stream<ListChange> getListChanges(String listName) {
        return this.getListItems(listName).map(item -> new ListChange(listName, ListChangeType.INSERT, item.id, null, item.value, null, item.prev, null, null, null, item.revisionId));
    }

    Stream<EntryList.ListEntrySnapshot> getListItems(String listName) {
        return this.getList(listName).map(EntryList::stream).orElseGet(Stream::empty);
    }

    EntryList.ListEntrySnapshot getListEntry(String listName, UUID key) {
        return this.getList(listName).map(list -> list.getEntry(key)).orElse(null);
    }

    JsonNode getListValue(String listName, UUID key) {
        return this.getList(listName).map(list -> list.getValue(key)).orElse(null);
    }

    private EntryList getOrCreateList(String listName) {
        return this.namedListData.computeIfAbsent(listName, name -> new EntryList());
    }

    private Optional<EntryList> getList(String listName) {
        return Optional.ofNullable(this.namedListData.get(listName));
    }

    void setChangeResultTracker(UUID id, SerializableConsumer<ChangeResult> changeResultTracker) {
        SerializableConsumer<ChangeResult> oldTracker = this.changeResultTrackers.putIfAbsent(id, changeResultTracker);
        if (oldTracker != null) {
            throw new IllegalStateException("Cannot set a change-result tracker for an id with one already set");
        }
    }

    boolean hasChangeListeners() {
        return !this.changeListeners.isEmpty();
    }

    static class Snapshot {
        private static final TypeReference<Map<String, EntryList>> LISTS_TYPE = new TypeReference<Map<String, EntryList>>(){};
        private static final TypeReference<Map<String, Map<String, Entry>>> MAPS_TYPE = new TypeReference<Map<String, Map<String, Entry>>>(){};
        private static final TypeReference<Map<String, Duration>> TIMEOUTS_TYPE = new TypeReference<Map<String, Duration>>(){};
        private static final TypeReference<List<UUID>> NODES_TYPE = new TypeReference<List<UUID>>(){};
        private static final String LATEST = "latest";
        private static final String LISTS = "lists";
        private static final String MAPS = "maps";
        private static final String LIST_TIMEOUTS = "list-timeouts";
        private static final String MAP_TIMEOUTS = "map-timeouts";
        private static final String ACTIVE_NODES = "active-nodes";
        private static final String BACKEND_NODES = "backend-nodes";
        private final ObjectNode objectNode;

        Snapshot(ObjectNode objectNode) {
            this.objectNode = Objects.requireNonNull(objectNode);
        }

        static Snapshot fromTopic(Topic topic, UUID latestChangeId) {
            ObjectNode objectNode = JsonUtil.getObjectMapper().createObjectNode();
            objectNode.put(LATEST, latestChangeId.toString());
            objectNode.set(LISTS, JsonUtil.toJsonNode(topic.namedListData));
            objectNode.set(MAPS, JsonUtil.toJsonNode(topic.namedMapData));
            objectNode.set(LIST_TIMEOUTS, JsonUtil.toJsonNode(topic.listExpirationTimeouts));
            objectNode.set(MAP_TIMEOUTS, JsonUtil.toJsonNode(topic.mapExpirationTimeouts));
            objectNode.set(ACTIVE_NODES, JsonUtil.toJsonNode(topic.activeNodes));
            objectNode.set(BACKEND_NODES, JsonUtil.toJsonNode(topic.backendNodes));
            return new Snapshot(objectNode);
        }

        ObjectNode toObjectNode() {
            return this.objectNode;
        }

        Map<String, EntryList> getLists() {
            return JsonUtil.toInstance(this.objectNode.get(LISTS), LISTS_TYPE);
        }

        Map<String, Map<String, Entry>> getMaps() {
            return JsonUtil.toInstance(this.objectNode.get(MAPS), MAPS_TYPE);
        }

        Map<String, Duration> getListTimeouts() {
            return JsonUtil.toInstance(this.objectNode.get(LIST_TIMEOUTS), TIMEOUTS_TYPE);
        }

        Map<String, Duration> getMapTimeouts() {
            return JsonUtil.toInstance(this.objectNode.get(MAP_TIMEOUTS), TIMEOUTS_TYPE);
        }

        List<UUID> getActiveNodes() {
            return JsonUtil.toInstance(this.objectNode.get(ACTIVE_NODES), NODES_TYPE);
        }

        List<UUID> getBackendNodes() {
            return JsonUtil.toInstance(this.objectNode.get(BACKEND_NODES), NODES_TYPE);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    static class Entry {
        final UUID revisionId;
        final JsonNode data;
        final UUID scopeOwnerId;

        @JsonCreator
        public Entry(@JsonProperty(value="id") UUID id, @JsonProperty(value="data") JsonNode data, @JsonProperty(value="scopeOwnerId") UUID scopeOwnerId) {
            this.revisionId = id;
            this.data = data;
            this.scopeOwnerId = scopeOwnerId;
        }
    }

    static interface ChangeDetails {
    }

    static enum ChangeResult {
        ACCEPTED,
        REJECTED;

    }
}

