/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.core.type.TypeReference;
import com.vaadin.collaborationengine.EntryScope;
import com.vaadin.collaborationengine.HasExpirationTimeout;
import com.vaadin.collaborationengine.ListKey;
import com.vaadin.collaborationengine.ListOperation;
import com.vaadin.collaborationengine.ListOperationResult;
import com.vaadin.collaborationengine.ListSubscriber;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.flow.shared.Registration;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface CollaborationList
extends HasExpirationTimeout {
    public <T> List<T> getItems(Class<T> var1);

    public <T> List<T> getItems(TypeReference<T> var1);

    public <T> T getItem(ListKey var1, Class<T> var2);

    public <T> T getItem(ListKey var1, TypeReference<T> var2);

    public Stream<ListKey> getKeys();

    public ListOperationResult<Boolean> apply(ListOperation var1);

    default public ListOperationResult<Void> insertFirst(Object item) {
        ListOperation operation = ListOperation.insertFirst(item);
        return this.apply(operation).mapToVoid();
    }

    @Deprecated(since="5.1", forRemoval=true)
    default public ListOperationResult<Void> insertFirst(Object item, EntryScope scope) {
        ListOperation operation = ListOperation.insertFirst(item).withScope(scope);
        return this.apply(operation).mapToVoid();
    }

    default public ListOperationResult<Void> insertLast(Object item) {
        ListOperation operation = ListOperation.insertLast(item);
        return this.apply(operation).mapToVoid();
    }

    @Deprecated(since="5.1", forRemoval=true)
    default public ListOperationResult<Void> insertLast(Object item, EntryScope scope) {
        ListOperation operation = ListOperation.insertLast(item).withScope(scope);
        return this.apply(operation).mapToVoid();
    }

    default public ListOperationResult<Boolean> insertBefore(ListKey key, Object item) {
        ListOperation operation = ListOperation.insertBefore(key, item);
        return this.apply(operation);
    }

    @Deprecated(since="5.1", forRemoval=true)
    default public ListOperationResult<Boolean> insertBefore(ListKey key, Object item, EntryScope scope) {
        ListOperation operation = ListOperation.insertBefore(key, item).withScope(scope);
        return this.apply(operation);
    }

    default public ListOperationResult<Boolean> insertAfter(ListKey key, Object item) {
        ListOperation operation = ListOperation.insertAfter(key, item);
        return this.apply(operation);
    }

    @Deprecated(since="5.1", forRemoval=true)
    default public ListOperationResult<Boolean> insertAfter(ListKey key, Object item, EntryScope scope) {
        ListOperation operation = ListOperation.insertAfter(key, item).withScope(scope);
        return this.apply(operation);
    }

    public CompletableFuture<Boolean> moveBefore(ListKey var1, ListKey var2);

    public CompletableFuture<Boolean> moveAfter(ListKey var1, ListKey var2);

    default public CompletableFuture<Boolean> set(ListKey key, Object value) {
        return this.set(key, value, EntryScope.TOPIC);
    }

    public CompletableFuture<Boolean> set(ListKey var1, Object var2, EntryScope var3);

    default public CompletableFuture<Boolean> remove(ListKey key) {
        return this.set(key, null);
    }

    @Deprecated(since="4.0", forRemoval=true)
    default public CompletableFuture<Void> append(Object item) {
        return this.append(item, EntryScope.TOPIC);
    }

    @Deprecated(since="4.0", forRemoval=true)
    default public CompletableFuture<Void> append(Object item, EntryScope scope) {
        return this.insertLast(item, scope).getCompletableFuture();
    }

    public Registration subscribe(ListSubscriber var1);

    public TopicConnection getConnection();

    @Override
    public Optional<Duration> getExpirationTimeout();

    @Override
    public void setExpirationTimeout(Duration var1);
}

