/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.TopicConnectionRegistration;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;

public abstract class AbstractCollaborationManager {
    private final CollaborationEngine collaborationEngine;
    private final UserInfo localUser;
    private final String topicId;
    private TopicConnectionRegistration topicRegistration;
    private ActivationHandler activationHandler;
    private Registration deactivationHandler;
    private TopicConnectionRegistration.ConnectionFailedAction connectionFailedAction;
    private boolean active;

    protected AbstractCollaborationManager(UserInfo localUser, String topicId, CollaborationEngine collaborationEngine) {
        this.localUser = Objects.requireNonNull(localUser);
        this.topicId = Objects.requireNonNull(topicId);
        this.collaborationEngine = Objects.requireNonNull(collaborationEngine);
    }

    protected void openTopicConnection(ConnectionContext context, SerializableFunction<TopicConnection, Registration> connectionActivationCallback) {
        if (this.topicRegistration != null) {
            this.topicRegistration.remove();
        }
        this.topicRegistration = this.collaborationEngine.openTopicConnection(context, this.topicId, this.localUser, (SerializableFunction<TopicConnection, Registration>)(SerializableFunction & Serializable)connection -> {
            this.active = true;
            Registration callbackRegistration = (Registration)connectionActivationCallback.apply(connection);
            if (this.activationHandler != null) {
                this.deactivationHandler = this.activationHandler.onActivation();
            }
            return callbackRegistration != null ? Registration.combine((Registration[])new Registration[]{callbackRegistration, this::onTopicRegistrationRemove}) : this::onTopicRegistrationRemove;
        });
        if (this.connectionFailedAction != null) {
            this.topicRegistration.onConnectionFailed(this.connectionFailedAction);
        }
    }

    public void setActivationHandler(ActivationHandler handler) {
        if (this.deactivationHandler != null) {
            this.deactivationHandler.remove();
            this.deactivationHandler = null;
        }
        this.activationHandler = handler;
        if (this.active && this.activationHandler != null) {
            this.deactivationHandler = this.activationHandler.onActivation();
        }
    }

    public void onConnectionFailed(TopicConnectionRegistration.ConnectionFailedAction connectionFailedAction) {
        this.connectionFailedAction = connectionFailedAction;
        if (connectionFailedAction != null && this.topicRegistration != null) {
            this.topicRegistration.onConnectionFailed(connectionFailedAction);
        }
    }

    private void onTopicRegistrationRemove() {
        if (this.deactivationHandler != null) {
            this.deactivationHandler.remove();
        }
        this.active = false;
    }

    protected CollaborationEngine getCollaborationEngine() {
        return this.collaborationEngine;
    }

    public UserInfo getLocalUser() {
        return this.localUser;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void close() {
        if (this.topicRegistration != null) {
            this.topicRegistration.remove();
            this.topicRegistration = null;
        }
    }

    @FunctionalInterface
    public static interface ActivationHandler
    extends Serializable {
        public Registration onActivation();
    }
}

