/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;

public class ServletUtil {
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";

    public static String getRequestUri(HttpServletRequest request) {
        String uri = ServletUtil.valueOrEmpty(request.getContextPath()) + "/" + ServletUtil.valueOrEmpty(request.getServletPath()) + ServletUtil.valueOrEmpty(request.getPathInfo());
        return ServletUtil.normalize(ServletUtil.decodeAndCleanUriString(request, uri));
    }

    public static String valueOrEmpty(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private static String decodeAndCleanUriString(HttpServletRequest request, String uri) {
        uri = ServletUtil.decodeRequestString(request, uri);
        return ServletUtil.removeSemicolon(uri);
    }

    private static String removeSemicolon(String uri) {
        int semicolonIndex = uri.indexOf(59);
        return semicolonIndex != -1 ? uri.substring(0, semicolonIndex) : uri;
    }

    public static String decodeRequestString(HttpServletRequest request, String source) {
        String enc = ServletUtil.determineEncoding(request);
        try {
            return URLDecoder.decode(source, enc);
        }
        catch (UnsupportedEncodingException ex) {
            return URLDecoder.decode(source);
        }
    }

    protected static String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = DEFAULT_CHARACTER_ENCODING;
        }
        return enc;
    }

    private static String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if ("/.".equals(normalized)) {
            return "/";
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }
}

