/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.creater;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.support.PasswordSubject;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class BasicSubjectSpringReactiveCreator
implements SubjectCreate {
    private static final Logger logger = LoggerFactory.getLogger(BasicSubjectSpringReactiveCreator.class);
    private static final int COUNT_2 = 2;

    @Override
    public boolean canSupportSubject(Object context) {
        if (context instanceof ServerHttpRequest) {
            String authorization = ((ServerHttpRequest)context).getHeaders().getFirst("Authorization");
            return authorization != null && authorization.startsWith("Basic");
        }
        return false;
    }

    @Override
    public Subject createSubject(Object context) {
        String authorization = ((ServerHttpRequest)context).getHeaders().getFirst("Authorization");
        if (authorization == null) {
            return null;
        }
        String basicAuth = authorization.replace("Basic", "").trim();
        basicAuth = new String(Base64.getDecoder().decode(basicAuth), StandardCharsets.UTF_8);
        String[] auth = basicAuth.split(":");
        if (auth.length != 2) {
            if (logger.isInfoEnabled()) {
                logger.info("can not create basic auth PasswordSubject by this request message");
            }
            return null;
        }
        String username = auth[0];
        if (username == null || "".equals(username)) {
            if (logger.isInfoEnabled()) {
                logger.info("can not create basic auth PasswordSubject by this request message, appId can not null");
            }
            return null;
        }
        String password = auth[1];
        InetSocketAddress remoteAddress = ((ServerHttpRequest)context).getRemoteAddress();
        String remoteHost = remoteAddress == null ? "" : remoteAddress.getHostString();
        String requestUri = ((ServerHttpRequest)context).getPath().value();
        String requestType = ((ServerHttpRequest)context).getMethodValue();
        String targetUri = requestUri.concat("===").concat(requestType).toLowerCase();
        return PasswordSubject.builder(username, password).setRemoteHost(remoteHost).setTargetResource(targetUri).build();
    }
}

