/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tags.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.tags.model.TagListView;
import java.util.Optional;

public class TagListListingResponse {
    private final boolean ok;
    private final ImmutableList<TagListView> TagListView;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private TagListListingResponse(@JsonProperty(value="ok") Boolean ok, @JsonProperty(value="lists") ImmutableList<TagListView> TagListView2, @JsonProperty(value="error") String error, @JsonProperty(value="details") ErrorDetails errorDetails) {
        this.ok = ok;
        this.TagListView = TagListView2;
        this.error = Optional.ofNullable(error);
        this.errorDetails = Optional.ofNullable(errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public ImmutableList<TagListView> getTagListView() {
        return this.TagListView;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "TagListListingResponse{ok=" + this.ok + ", TagListView=" + this.TagListView + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.TagListView, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TagListListingResponse other = (TagListListingResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.TagListView, other.TagListView) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        private boolean ok;
        private ImmutableList.Builder<TagListView> TagListObjects = ImmutableList.builder();
        private String error;
        private ErrorDetails errorDetails;

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder addTagList(TagListView TagListObject) {
            this.TagListObjects.add((Object)TagListObject);
            return this;
        }

        public Builder addAllTagList(Iterable<? extends TagListView> TagListObjects) {
            this.TagListObjects.addAll(TagListObjects);
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public TagListListingResponse build() {
            return new TagListListingResponse(this.ok, this.TagListObjects.build(), this.error, this.errorDetails);
        }
    }
}

