/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tags;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class TagListUploadRequest
implements Request<String> {
    private static final String TAG_LIST_PATH = "/api/tag-lists/";
    private static final String CSV_PATH = "/csv";
    private final String path;
    private File csv;
    private Boolean gzip = false;

    private TagListUploadRequest(String path, File csv) {
        this.path = path;
        this.csv = csv;
    }

    public static TagListUploadRequest newRequest(String name, String csvFile) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"List name cannot be null.");
        File csv = new File(csvFile);
        Preconditions.checkArgument((csv.exists() && csv.isFile() ? 1 : 0) != 0, (Object)("File does not exist: " + csvFile));
        return new TagListUploadRequest(TAG_LIST_PATH + name + CSV_PATH, csv);
    }

    public Boolean getGzipEnabled() {
        return this.gzip;
    }

    public TagListUploadRequest setGzipEnabled(Boolean gzip) {
        this.gzip = gzip;
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.TEXT_PLAIN;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        headers.put("Content-Type", "text/csv");
        if (this.gzip.booleanValue()) {
            headers.put("Content-Encoding", "gzip");
        }
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.PUT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getRequestBody() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csv));){
            String line;
            StringBuffer body = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                body.append(line).append("\n");
            }
            String string = body.toString();
            return string;
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return response -> response;
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

