/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.urbanairship.api.push.model.PushPayload;
import com.urbanairship.api.schedule.model.Schedule;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class SchedulePayloadResponse {
    private final Schedule schedule;
    private final Optional<String> url;
    private final Optional<String> name;
    private final PushPayload pushPayload;
    private Set<String> pushIds;

    private SchedulePayloadResponse(Schedule schedule, String url, String name, PushPayload pushPayload, Set<String> pushIds) {
        this.schedule = schedule;
        this.url = Optional.ofNullable(url);
        this.name = Optional.ofNullable(name);
        this.pushPayload = pushPayload;
        this.pushIds = pushIds;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public PushPayload getPushPayload() {
        return this.pushPayload;
    }

    public Set<String> getPushIds() {
        return this.pushIds;
    }

    public void addPushId(String pushId) {
        this.pushIds.add(pushId);
    }

    public void addAllPushIds(Collection<String> pushIds) {
        this.pushIds.addAll(pushIds);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "SchedulePayloadResponse{schedule=" + this.schedule + ", url=" + this.url + ", name=" + this.name + ", pushPayload=" + this.pushPayload + ", pushIds=" + this.pushIds + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.schedule, this.url, this.name, this.pushPayload, this.pushIds});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SchedulePayloadResponse other = (SchedulePayloadResponse)obj;
        return Objects.equal((Object)this.schedule, (Object)other.schedule) && Objects.equal(this.url, other.url) && Objects.equal(this.name, other.name) && Objects.equal((Object)this.pushPayload, (Object)other.pushPayload) && Objects.equal(this.pushIds, other.pushIds);
    }

    public static class Builder {
        private Schedule schedule = null;
        private String url = null;
        private String name = null;
        private PushPayload pushPayload = null;
        private Set<String> pushIds = Sets.newHashSet();

        private Builder() {
        }

        public Builder setSchedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPushPayload(PushPayload pushPayload) {
            this.pushPayload = pushPayload;
            return this;
        }

        public Builder addPushId(String pushId) {
            this.pushIds.add(pushId);
            return this;
        }

        public Builder addAllPushIds(Collection<String> pushIds) {
            this.pushIds.addAll(pushIds);
            return this;
        }

        public SchedulePayloadResponse build() {
            Preconditions.checkNotNull((Object)this.schedule, (Object)"'schedule' must be set");
            Preconditions.checkNotNull((Object)this.pushPayload, (Object)"'pushPayload' must be set");
            if (this.name != null) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.name), (Object)"'name' must be a non-blank string");
            }
            return new SchedulePayloadResponse(this.schedule, this.url, this.name, this.pushPayload, this.pushIds);
        }
    }
}

