/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.schedule.model.BestTime;
import com.urbanairship.api.schedule.model.ScheduleModelObject;
import java.util.Optional;
import org.joda.time.DateTime;

public final class Schedule
extends ScheduleModelObject {
    private final DateTime scheduledTimestamp;
    private final Boolean localTimePresent;
    private final Optional<BestTime> bestTime;

    private Schedule(Builder builder) {
        this.scheduledTimestamp = builder.scheduledTimestamp;
        this.localTimePresent = builder.localTimePresent;
        this.bestTime = Optional.ofNullable(builder.bestTime);
    }

    public DateTime getScheduledTimestamp() {
        return this.scheduledTimestamp;
    }

    public Boolean getLocalTimePresent() {
        return this.localTimePresent;
    }

    public Optional<BestTime> getBestTime() {
        return this.bestTime;
    }

    public String toString() {
        return "Schedule{scheduledTimestamp=" + this.scheduledTimestamp + ", localTimePresent=" + this.localTimePresent + ", scheduledBestTime=" + this.bestTime + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scheduledTimestamp, this.localTimePresent});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equal((Object)this.scheduledTimestamp, (Object)other.scheduledTimestamp) && Objects.equal((Object)this.localTimePresent, (Object)other.localTimePresent);
    }

    public static class Builder {
        private DateTime scheduledTimestamp = null;
        private Boolean localTimePresent = false;
        private BestTime bestTime = null;

        private Builder() {
        }

        public Builder setScheduledTimestamp(DateTime scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
            this.localTimePresent = false;
            return this;
        }

        public Builder setLocalScheduledTimestamp(DateTime scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
            this.localTimePresent = true;
            return this;
        }

        public Builder setBestTime(BestTime bestTime) {
            this.bestTime = bestTime;
            return this;
        }

        public Schedule build() {
            Preconditions.checkArgument((boolean)this.argumentValidator(this.scheduledTimestamp, this.bestTime), (Object)"Either scheduled_time or best_time must be set.");
            return new Schedule(this);
        }

        private boolean argumentValidator(DateTime scheduledTimestamp, BestTime bestTime) {
            int argumentSet = 0;
            if (scheduledTimestamp != null) {
                ++argumentSet;
            }
            if (bestTime != null) {
                ++argumentSet;
            }
            return argumentSet == 1;
        }
    }
}

