/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.model.WebCountsStats;
import java.util.Objects;
import org.joda.time.DateTime;

public class WebCounts {
    private final WebCountsStats counts;
    private final DateTime date;

    public WebCounts(@JsonProperty(value="counts") WebCountsStats counts, @JsonProperty(value="date") String dateString) {
        this.counts = counts;
        this.date = DateFormats.DATE_PARSER.parseDateTime(dateString);
    }

    public WebCountsStats getCounts() {
        return this.counts;
    }

    public DateTime getDate() {
        return this.date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebCounts webCounts = (WebCounts)o;
        return Objects.equals(this.counts, webCounts.counts) && Objects.equals(this.date, webCounts.date);
    }

    public int hashCode() {
        return Objects.hash(this.counts, this.date);
    }

    public String toString() {
        return "WebCounts{counts=" + this.counts + ", date=" + this.date + '}';
    }
}

