/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.model.ExperimentControl;
import com.urbanairship.api.reports.model.ExperimentVariant;
import java.util.Objects;
import org.joda.time.DateTime;

public class ExperimentOverviewReportResponse {
    private final boolean ok;
    private final String appKey;
    private final String experimentId;
    private final String pushId;
    private final DateTime created;
    private final Integer sends;
    private final Integer directResponses;
    private final Integer influencedResponses;
    private final Integer webClicks;
    private final Integer webSessions;
    private final ImmutableList<ExperimentVariant> experimentVariants;
    private final ExperimentControl experimentControl;
    private final String error;
    private final Integer errorCode;

    public ExperimentOverviewReportResponse(@JsonProperty(value="ok") boolean ok, @JsonProperty(value="app_key") String appKey, @JsonProperty(value="experiment_id") String experimentId, @JsonProperty(value="push_id") String pushId, @JsonProperty(value="created") String createdString, @JsonProperty(value="sends") Integer sends, @JsonProperty(value="direct_responses") Integer directResponses, @JsonProperty(value="influenced_responses") Integer influencedResponses, @JsonProperty(value="web_clicks") Integer webClicks, @JsonProperty(value="web_sessions") Integer webSessions, @JsonProperty(value="variants") ImmutableList<ExperimentVariant> experimentVariants, @JsonProperty(value="control") ExperimentControl experimentControl, @JsonProperty(value="error") String error, @JsonProperty(value="error_code") Integer errorCode) {
        this.ok = ok;
        this.appKey = appKey;
        this.experimentId = experimentId;
        this.pushId = pushId;
        this.created = DateFormats.DATE_PARSER.parseDateTime(createdString);
        this.sends = sends;
        this.directResponses = directResponses;
        this.influencedResponses = influencedResponses;
        this.webClicks = webClicks;
        this.webSessions = webSessions;
        this.experimentVariants = experimentVariants;
        this.experimentControl = experimentControl;
        this.error = error;
        this.errorCode = errorCode;
    }

    public boolean getOk() {
        return this.ok;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public String getPushId() {
        return this.pushId;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Integer getSends() {
        return this.sends;
    }

    public Integer getDirectResponses() {
        return this.directResponses;
    }

    public Integer getInfluencedResponses() {
        return this.influencedResponses;
    }

    public Integer getWebClicks() {
        return this.webClicks;
    }

    public Integer getWebSessions() {
        return this.webSessions;
    }

    public ImmutableList<ExperimentVariant> getExperimentVariants() {
        return this.experimentVariants;
    }

    public ExperimentControl getExperimentControl() {
        return this.experimentControl;
    }

    public String getError() {
        return this.error;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExperimentOverviewReportResponse that = (ExperimentOverviewReportResponse)o;
        return this.ok == that.ok && Objects.equals(this.appKey, that.appKey) && Objects.equals(this.experimentId, that.experimentId) && Objects.equals(this.pushId, that.pushId) && Objects.equals(this.created, that.created) && Objects.equals(this.sends, that.sends) && Objects.equals(this.directResponses, that.directResponses) && Objects.equals(this.influencedResponses, that.influencedResponses) && Objects.equals(this.webClicks, that.webClicks) && Objects.equals(this.webSessions, that.webSessions) && Objects.equals(this.experimentVariants, that.experimentVariants) && Objects.equals(this.experimentControl, that.experimentControl) && Objects.equals(this.error, that.error) && Objects.equals(this.errorCode, that.errorCode);
    }

    public int hashCode() {
        return Objects.hash(this.ok, this.appKey, this.experimentId, this.pushId, this.created, this.sends, this.directResponses, this.influencedResponses, this.webClicks, this.webSessions, this.experimentVariants, this.experimentControl, this.error, this.errorCode);
    }

    public String toString() {
        return "ExperimentOverviewReportResponse{ok=" + this.ok + ", appKey='" + this.appKey + '\'' + ", experimentId='" + this.experimentId + '\'' + ", pushId='" + this.pushId + '\'' + ", created='" + this.created + '\'' + ", sends=" + this.sends + ", directResponses=" + this.directResponses + ", influencedResponses=" + this.influencedResponses + ", webClicks=" + this.webClicks + ", webSessions=" + this.webSessions + ", experimentVariants=" + this.experimentVariants + ", experimentControl=" + this.experimentControl + ", error='" + this.error + '\'' + ", errorCode=" + this.errorCode + '}';
    }
}

