/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.reports.model.DeviceTypeStats;
import java.util.Objects;
import java.util.Optional;

public final class DevicesReportResponse {
    private Optional<ImmutableMap<String, DeviceTypeStats>> deviceStatsMap;

    private DevicesReportResponse() {
        this(Optional.empty());
    }

    private DevicesReportResponse(Optional<ImmutableMap<String, DeviceTypeStats>> deviceStatsMap) {
        this.deviceStatsMap = deviceStatsMap;
    }

    public Optional<ImmutableMap<String, DeviceTypeStats>> getDeviceTypeStatsMap() {
        return this.deviceStatsMap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DevicesReportResponse that = (DevicesReportResponse)o;
        return Objects.equals(this.deviceStatsMap, that.deviceStatsMap);
    }

    public int hashCode() {
        return Objects.hash(this.deviceStatsMap);
    }

    public String toString() {
        return "DevicesReportResponse{deviceStatsMap=" + this.deviceStatsMap + '}';
    }

    public static class Builder {
        private ImmutableMap.Builder<String, DeviceTypeStats> deviceStatsMap = ImmutableMap.builder();

        private Builder() {
        }

        public Builder addDeviceTypeStatsMapping(String value, DeviceTypeStats object) {
            this.deviceStatsMap.put((Object)value, (Object)object);
            return this;
        }

        public DevicesReportResponse build() {
            return new DevicesReportResponse(Optional.ofNullable(this.deviceStatsMap.build()));
        }
    }
}

