/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.reports.model.ExperimentOverviewReportResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class ExperimentOverviewReportRequest
implements Request<ExperimentOverviewReportResponse> {
    private static final String API_EXPERIMENT_OVERVIEW_REPORT = "/api/reports/experiment/overview/";
    private final String path;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private ExperimentOverviewReportRequest(String path) {
        this.path = path;
    }

    public static ExperimentOverviewReportRequest newRequest(String pushId) {
        return new ExperimentOverviewReportRequest(API_EXPERIMENT_OVERVIEW_REPORT + pushId);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<ExperimentOverviewReportResponse> getResponseParser() {
        return response -> (ExperimentOverviewReportResponse)MAPPER.readValue(response, ExperimentOverviewReportResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }

    static {
        MAPPER.registerModule((Module)new GuavaModule());
    }
}

