/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.model.CustomEventsDetailsListingResponse;
import com.urbanairship.api.reports.model.Precision;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class CustomEventsDetailsListingRequest
implements Request<CustomEventsDetailsListingResponse> {
    private static final String API_RESPONSE_REPORT = "/api/reports/events/";
    private final String path;
    private final boolean nextPageRequest;
    private DateTime start;
    private DateTime end;
    private Precision precision;
    private Integer page;
    private Integer pageSize;
    private static final ObjectMapper mapper = new ObjectMapper();

    private CustomEventsDetailsListingRequest(DateTime start, DateTime end, String path, boolean nextPageRequest) {
        this.path = path;
        this.nextPageRequest = nextPageRequest;
        this.start = start;
        this.end = end;
    }

    public static CustomEventsDetailsListingRequest newRequest(DateTime start, DateTime end) {
        return new CustomEventsDetailsListingRequest(start, end, API_RESPONSE_REPORT, false);
    }

    public static CustomEventsDetailsListingRequest newRequest(DateTime start, DateTime end, URI nextPage) {
        Preconditions.checkNotNull((Object)nextPage, (Object)"Next page URI cannot be null");
        return new CustomEventsDetailsListingRequest(start, end, nextPage.getPath() + "?" + nextPage.getQuery(), true);
    }

    public CustomEventsDetailsListingRequest setPrecision(Precision precision) {
        this.precision = precision;
        return this;
    }

    public CustomEventsDetailsListingRequest setPage(Integer page) {
        this.page = page;
        return this;
    }

    public CustomEventsDetailsListingRequest setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) {
        URI uri;
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, this.path));
        if (!this.nextPageRequest) {
            Preconditions.checkNotNull((Object)this.start, (Object)"start cannot be null");
            Preconditions.checkNotNull((Object)this.end, (Object)"end cannot be null");
            Preconditions.checkArgument((boolean)this.end.isAfter((ReadableInstant)this.start), (Object)"end date must occur after start date");
            builder.addParameter("start", this.start.toString(DateFormats.DATE_FORMATTER));
            builder.addParameter("end", this.end.toString(DateFormats.DATE_FORMATTER));
            if (this.precision != null) {
                builder.addParameter("precision", this.precision.toString());
            }
            if (this.page != null) {
                builder.addParameter("page", this.page.toString());
            }
            if (this.pageSize != null) {
                builder.addParameter("page_size", this.pageSize.toString());
            }
        }
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    @Override
    public ResponseParser<CustomEventsDetailsListingResponse> getResponseParser() {
        return response -> (CustomEventsDetailsListingResponse)mapper.readValue(response, CustomEventsDetailsListingResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }

    static {
        mapper.registerModule((Module)new GuavaModule());
    }
}

