/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.android;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.android.Wearable;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class WearableReader
implements JsonObjectReader<Wearable> {
    private final Wearable.Builder builder = Wearable.newBuilder();

    public void readBackgroundImage(JsonParser parser) throws IOException {
        this.builder.setBackgroundImage(StringFieldDeserializer.INSTANCE.deserialize(parser, "background_image"));
    }

    public void readInteractive(JsonParser parser) throws IOException {
        this.builder.setInteractive((Interactive)parser.readValueAs(Interactive.class));
    }

    public void readExtraPages(JsonParser parser) throws IOException {
        List mutablePages = (List)parser.readValueAs((TypeReference)new TypeReference<List<Map<String, String>>>(){});
        this.builder.addAllExtraPages((List<ImmutableMap<String, String>>)WearableReader.immutableMapsConverter(mutablePages));
    }

    @Override
    public Wearable validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), e);
        }
    }

    private static ImmutableList<ImmutableMap<String, String>> immutableMapsConverter(List<Map<String, String>> maps) {
        ImmutableList.Builder pages = ImmutableList.builder();
        for (Map<String, String> map : maps) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            pages.add((Object)builder.build());
        }
        return pages.build();
    }
}

