/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.web;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.actions.Actions;
import com.urbanairship.api.push.model.notification.web.Button;
import com.urbanairship.api.push.model.notification.web.WebIcon;
import com.urbanairship.api.push.model.notification.web.WebImage;
import com.urbanairship.api.push.model.notification.web.WebTemplate;
import java.util.Map;
import java.util.Optional;

public final class WebDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<String> title;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<WebIcon> webIcon;
    private final Optional<Boolean> requireInteraction;
    private final Optional<Actions> actions;
    private final Optional<WebImage> webImage;
    private final Optional<PushExpiry> expiry;
    private final Optional<ImmutableList<Button>> buttons;
    private final Optional<WebTemplate> template;

    private WebDevicePayload(Builder builder) {
        this.alert = Optional.ofNullable(builder.alert);
        this.title = Optional.ofNullable(builder.title);
        this.webIcon = Optional.ofNullable(builder.webIcon);
        this.requireInteraction = Optional.ofNullable(builder.requireInteraction);
        this.actions = Optional.ofNullable(builder.actions);
        this.webImage = Optional.ofNullable(builder.webImage);
        this.expiry = Optional.ofNullable(builder.expiry);
        this.template = Optional.ofNullable(builder.webTemplate);
        this.buttons = builder.buttons.build().isEmpty() ? Optional.empty() : Optional.of(builder.buttons.build());
        this.extra = builder.extra.build().isEmpty() ? Optional.empty() : Optional.of(builder.extra.build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.WEB;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public Optional<WebIcon> getWebIcon() {
        return this.webIcon;
    }

    public Optional<Boolean> getRequireInteraction() {
        return this.requireInteraction;
    }

    public Optional<Actions> getActions() {
        return this.actions;
    }

    public Optional<WebImage> getWebImage() {
        return this.webImage;
    }

    public Optional<PushExpiry> getExpiry() {
        return this.expiry;
    }

    public Optional<ImmutableList<Button>> getButtons() {
        return this.buttons;
    }

    public Optional<WebTemplate> getTemplate() {
        return this.template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDevicePayload payload = (WebDevicePayload)o;
        return Objects.equal(this.alert, payload.alert) && Objects.equal(this.title, payload.title) && Objects.equal(this.extra, payload.extra) && Objects.equal(this.webIcon, payload.webIcon) && Objects.equal(this.requireInteraction, payload.requireInteraction) && Objects.equal(this.actions, payload.actions) && Objects.equal(this.webImage, payload.webImage) && Objects.equal(this.expiry, payload.expiry) && Objects.equal(this.buttons, payload.buttons) && Objects.equal(this.template, payload.template);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alert, this.title, this.extra, this.webIcon, this.requireInteraction, this.actions, this.webImage, this.expiry, this.buttons, this.template});
    }

    public String toString() {
        return "WebDevicePayload{alert=" + this.alert + ", title=" + this.title + ", extra=" + this.extra + ", webIcon=" + this.webIcon + ", requireInteraction=" + this.requireInteraction + ", actions=" + this.actions + ", webImage=" + this.webImage + ", expiry=" + this.expiry + ", buttons=" + this.buttons + ", template=" + this.template + '}';
    }

    public static class Builder {
        private String alert = null;
        private String title = null;
        private ImmutableMap.Builder<String, String> extra = ImmutableMap.builder();
        private WebIcon webIcon = null;
        private Boolean requireInteraction = null;
        private Actions actions = null;
        private WebImage webImage = null;
        private PushExpiry expiry = null;
        private ImmutableList.Builder<Button> buttons = ImmutableList.builder();
        private WebTemplate webTemplate = null;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            this.extra.putAll(entries);
            return this;
        }

        public Builder setWebIcon(WebIcon webIcon) {
            this.webIcon = webIcon;
            return this;
        }

        public Builder setRequireInteraction(boolean value) {
            this.requireInteraction = value;
            return this;
        }

        public Builder setActions(Actions actions) {
            this.actions = actions;
            return this;
        }

        public Builder setWebImage(WebImage webImage) {
            this.webImage = webImage;
            return this;
        }

        public Builder setExpiry(PushExpiry expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder addButton(Button button) {
            this.buttons.add((Object)button);
            return this;
        }

        public Builder addAllButtons(Iterable<? extends Button> buttons) {
            this.buttons.addAll(buttons);
            return this;
        }

        public Builder setTemplate(WebTemplate webTemplate) {
            this.webTemplate = webTemplate;
            return this;
        }

        public WebDevicePayload build() {
            return new WebDevicePayload(this);
        }
    }
}

