/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.Objects;
import java.util.Optional;

public final class IOSSoundData
extends PushModelObject {
    private final Optional<Boolean> critical;
    private final Optional<Double> volume;
    private final Optional<String> name;

    public IOSSoundData(Optional<Boolean> critical, Optional<Double> volume, Optional<String> name) {
        this.critical = critical;
        this.volume = volume;
        this.name = name;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Boolean> getCritical() {
        return this.critical;
    }

    public Optional<Double> getVolume() {
        return this.volume;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSSoundData that = (IOSSoundData)o;
        return Objects.equals(this.critical, that.critical) && Objects.equals(this.volume, that.volume) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.critical, this.volume, this.name);
    }

    public String toString() {
        return "IOSSoundData{critical=" + this.critical + ", volume=" + this.volume + ", name='" + this.name + '\'' + '}';
    }

    public boolean shouldBeDict() {
        return this.critical.isPresent() && this.critical.get() != false;
    }

    public static class Builder {
        private Boolean critical = null;
        private Double volume = null;
        private String name = null;

        public Builder setCritical(Boolean critical) {
            this.critical = critical;
            return this;
        }

        public Builder setVolume(Double volume) {
            this.volume = volume;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public IOSSoundData build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"The sound file name cannot be null");
            return new IOSSoundData(Optional.ofNullable(this.critical), Optional.ofNullable(this.volume), Optional.ofNullable(this.name));
        }
    }
}

