/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.ios.Crop;
import java.util.Optional;

public final class IOSMediaOptions
extends PushModelObject {
    private final Optional<Integer> time;
    private final Optional<Crop> crop;
    private final Optional<Boolean> hidden;

    private IOSMediaOptions(Optional<Integer> time, Optional<Crop> crop, Optional<Boolean> hidden) {
        this.time = time;
        this.crop = crop;
        this.hidden = hidden;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Integer> getTime() {
        return this.time;
    }

    public Optional<Crop> getCrop() {
        return this.crop;
    }

    public Optional<Boolean> getHidden() {
        return this.hidden;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSMediaOptions that = (IOSMediaOptions)o;
        if (this.time != null ? !this.time.equals(that.time) : that.time != null) {
            return false;
        }
        return !(this.crop != null ? !this.crop.equals(that.crop) : that.crop != null);
    }

    public int hashCode() {
        int result = this.time != null ? this.time.hashCode() : 0;
        result = 31 * result + (this.crop != null ? this.crop.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IOSMediaOptions{time=" + this.time + ", crop=" + this.crop + '}';
    }

    public static class Builder {
        private Integer time = null;
        private Crop crop = null;
        private Boolean hidden = null;

        private Builder() {
        }

        public Builder setTime(Integer time) {
            this.time = time;
            return this;
        }

        public Builder setCrop(Crop crop) {
            this.crop = crop;
            return this;
        }

        public Builder setHidden(Boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public IOSMediaOptions build() {
            return new IOSMediaOptions(Optional.ofNullable(this.time), Optional.ofNullable(this.crop), Optional.ofNullable(this.hidden));
        }
    }
}

