/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.actions;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.actions.Action;
import com.urbanairship.api.push.model.notification.actions.ActionType;
import com.urbanairship.api.push.model.notification.actions.LandingPageContent;
import java.util.Optional;

public class OpenLandingPageWithContentAction
extends PushModelObject
implements Action.OpenAction<LandingPageContent> {
    private final LandingPageContent pageContent;
    private final Optional<String> fallbackUrl;

    public OpenLandingPageWithContentAction(LandingPageContent pageContent) {
        this(pageContent, Optional.empty());
    }

    public OpenLandingPageWithContentAction(LandingPageContent pageContent, String fallbackUrl) {
        this(pageContent, Optional.ofNullable(fallbackUrl));
    }

    private OpenLandingPageWithContentAction(LandingPageContent pageContent, Optional<String> fallbackUrl) {
        Preconditions.checkNotNull((Object)pageContent, (Object)"pageContent should not be null.");
        Preconditions.checkNotNull(fallbackUrl, (Object)"fallbackUrl should not be null.");
        this.pageContent = pageContent;
        this.fallbackUrl = fallbackUrl;
    }

    @Override
    public LandingPageContent getValue() {
        return this.pageContent;
    }

    public Optional<String> getFallbackUrl() {
        return this.fallbackUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenLandingPageWithContentAction that = (OpenLandingPageWithContentAction)o;
        return Objects.equal((Object)this.pageContent, (Object)that.pageContent) && Objects.equal(this.fallbackUrl, that.fallbackUrl);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pageContent, this.fallbackUrl});
    }

    @Override
    public ActionType getActionType() {
        return ActionType.OPEN_LANDING_PAGE_WITH_CONTENT;
    }

    public String toString() {
        return "OpenLandingPageWithContentAction{pageContent=" + this.pageContent + ", fallbackUrl=" + this.fallbackUrl + '}';
    }
}

