/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.actions;

import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.notification.actions.ActionType;

public final class ActionNameRegistry {
    public static final ActionNameRegistry INSTANCE = new ActionNameRegistry();
    private final ImmutableMap<ActionType, String> shortNames = ImmutableMap.builder().put((Object)ActionType.ADD_TAG, (Object)"^+t").put((Object)ActionType.REMOVE_TAG, (Object)"^-t").put((Object)ActionType.OPEN_EXTERNAL_URL, (Object)"^u").put((Object)ActionType.OPEN_LANDING_PAGE_WITH_CONTENT, (Object)"^p").put((Object)ActionType.OPEN_DEEP_LINK, (Object)"^d").put((Object)ActionType.SHARE, (Object)"^s").build();
    private final ImmutableMap<ActionType, String> longNames = ImmutableMap.builder().put((Object)ActionType.ADD_TAG, (Object)"add_tags_action").put((Object)ActionType.REMOVE_TAG, (Object)"remove_tags_action").put((Object)ActionType.OPEN_EXTERNAL_URL, (Object)"open_external_url_action").put((Object)ActionType.OPEN_LANDING_PAGE_WITH_CONTENT, (Object)"landing_page_action").put((Object)ActionType.OPEN_DEEP_LINK, (Object)"deep_link_action").put((Object)ActionType.SHARE, (Object)"share_action").build();
    private final ImmutableMap<ActionType, String> fieldNames = ImmutableMap.builder().put((Object)ActionType.ADD_TAG, (Object)"add_tag").put((Object)ActionType.REMOVE_TAG, (Object)"remove_tag").put((Object)ActionType.OPEN_EXTERNAL_URL, (Object)"open").put((Object)ActionType.OPEN_LANDING_PAGE_WITH_CONTENT, (Object)"open").put((Object)ActionType.OPEN_DEEP_LINK, (Object)"open").put((Object)ActionType.APP_DEFINED, (Object)"app_defined").put((Object)ActionType.SHARE, (Object)"share").build();

    private ActionNameRegistry() {
    }

    public String getShortName(ActionType actionType) {
        if (this.shortNames.containsKey((Object)actionType)) {
            return (String)this.shortNames.get((Object)actionType);
        }
        throw new RuntimeException("Can't find a short name for action type: " + actionType.name());
    }

    public String getLongName(ActionType actionType) {
        if (this.longNames.containsKey((Object)actionType)) {
            return (String)this.longNames.get((Object)actionType);
        }
        throw new RuntimeException("Can't find a long name for action type: " + actionType.name());
    }

    public String getFieldName(ActionType actionType) {
        if (this.fieldNames.containsKey((Object)actionType)) {
            return (String)this.fieldNames.get((Object)actionType);
        }
        throw new RuntimeException("Can't find a field name for action type: " + actionType.name());
    }
}

