/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience.sms;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.audience.SelectorVisitor;

public class SmsSelector
extends PushModelObject
implements Selector {
    private final String msisdn;
    private final String sender;

    private SmsSelector(Builder builder) {
        this.msisdn = builder.msisdn;
        this.sender = builder.sender;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public String getSender() {
        return this.sender;
    }

    @Override
    public SelectorType getType() {
        return SelectorType.SMS;
    }

    @Override
    public DeviceTypeData getApplicableDeviceTypes() {
        return DeviceTypeData.of(DeviceType.SMS);
    }

    @Override
    public void accept(SelectorVisitor visitor) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsSelector that = (SmsSelector)o;
        return Objects.equal((Object)this.msisdn, (Object)that.msisdn) && Objects.equal((Object)this.sender, (Object)that.sender);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.msisdn, this.sender});
    }

    public static class Builder {
        private String msisdn = null;
        private String sender = null;

        public Builder setMsisdn(String msisdn) {
            this.msisdn = msisdn;
            return this;
        }

        public Builder setSender(String sender) {
            this.sender = sender;
            return this;
        }

        public SmsSelector build() {
            Preconditions.checkNotNull((Object)this.msisdn, (Object)"msisdn must not be null.");
            Preconditions.checkNotNull((Object)this.sender, (Object)"sender must not be null.");
            return new SmsSelector(this);
        }
    }
}

