/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience.location;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.audience.location.LocationAlias;
import java.util.Optional;

public final class LocationIdentifier
extends PushModelObject {
    private final Optional<String> id;
    private final Optional<LocationAlias> alias;

    private LocationIdentifier(Optional<String> id, Optional<LocationAlias> alias) {
        this.id = id;
        this.alias = alias;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isAlias() {
        return this.alias != null && this.alias.isPresent();
    }

    public Optional<LocationAlias> getAlias() {
        return this.alias;
    }

    public Optional<String> getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationIdentifier that = (LocationIdentifier)o;
        if (this.alias.isPresent() && that.getAlias().isPresent()) {
            return this.alias.hashCode() == that.getAlias().hashCode();
        }
        if (this.id.isPresent() && that.getId().isPresent()) {
            return this.id.hashCode() == that.getId().hashCode();
        }
        return false;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LocationIdentifier{alias=" + this.alias + ", id='" + this.id + '\'' + '}';
    }

    public static class Builder {
        private String id;
        private LocationAlias alias;

        private Builder() {
        }

        public Builder setId(String value) {
            this.id = value;
            return this;
        }

        public Builder setAlias(LocationAlias value) {
            this.alias = value;
            return this;
        }

        public LocationIdentifier build() {
            Preconditions.checkArgument((this.id != null || this.alias != null ? 1 : 0) != 0, (Object)"Must have only one of 'id' or an alias");
            return new LocationIdentifier(Optional.ofNullable(this.id), Optional.ofNullable(this.alias));
        }
    }
}

