/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.Campaigns;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.InApp;
import com.urbanairship.api.push.model.Orchestration;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.PushOptions;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.localization.Localization;
import com.urbanairship.api.push.model.notification.Notification;
import com.urbanairship.api.push.model.notification.email.MessageType;
import com.urbanairship.api.push.model.notification.richpush.RichPushMessage;
import java.util.Objects;
import java.util.Optional;

public final class PushPayload
extends PushModelObject {
    private final Selector audience;
    private final Optional<Notification> notification;
    private final Optional<ImmutableList<Localization>> localizations;
    private final Optional<RichPushMessage> message;
    private final DeviceTypeData deviceTypes;
    private final Optional<PushOptions> pushOptions;
    private final Optional<InApp> inApp;
    private final Optional<Campaigns> campaigns;
    private final ImmutableMap<String, Object> globalAttributes;
    private final Optional<Orchestration> orchestration;
    private final Optional<MessageType> messageType;

    public static Builder newBuilder() {
        return new Builder();
    }

    private PushPayload(Selector audience, Optional<Notification> notification, Optional<RichPushMessage> message, DeviceTypeData deviceTypes, Optional<PushOptions> pushOptions, Optional<InApp> inApp, Optional<Campaigns> campaigns, ImmutableList<Localization> localizations, ImmutableMap<String, Object> globalAttributes, Optional<Orchestration> orchestration, Optional<MessageType> messageType) {
        this.audience = audience;
        this.notification = notification;
        this.message = message;
        this.deviceTypes = deviceTypes;
        this.pushOptions = pushOptions;
        this.inApp = inApp;
        this.campaigns = campaigns;
        this.globalAttributes = globalAttributes;
        this.orchestration = orchestration;
        this.messageType = messageType;
        this.localizations = localizations.isEmpty() ? Optional.empty() : Optional.of(localizations);
    }

    public Selector getAudience() {
        return this.audience;
    }

    public Optional<Notification> getNotification() {
        return this.notification;
    }

    public Optional<RichPushMessage> getMessage() {
        return this.message;
    }

    public DeviceTypeData getDeviceTypes() {
        return this.deviceTypes;
    }

    public boolean isBroadcast() {
        return this.audience.getType().equals((Object)SelectorType.ALL);
    }

    public Optional<InApp> getInApp() {
        return this.inApp;
    }

    public Optional<PushOptions> getPushOptions() {
        return this.pushOptions;
    }

    public Optional<Campaigns> getCampaigns() {
        return this.campaigns;
    }

    public Optional<ImmutableList<Localization>> getLocalizations() {
        return this.localizations;
    }

    public ImmutableMap<String, Object> getGlobalAttributes() {
        return this.globalAttributes;
    }

    public Optional<Orchestration> getOrchestration() {
        return this.orchestration;
    }

    public Optional<MessageType> getMessageType() {
        return this.messageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushPayload that = (PushPayload)o;
        return Objects.equals(this.audience, that.audience) && Objects.equals(this.notification, that.notification) && Objects.equals(this.localizations, that.localizations) && Objects.equals(this.message, that.message) && Objects.equals(this.deviceTypes, that.deviceTypes) && Objects.equals(this.pushOptions, that.pushOptions) && Objects.equals(this.inApp, that.inApp) && Objects.equals(this.campaigns, that.campaigns) && Objects.equals(this.globalAttributes, that.globalAttributes) && Objects.equals(this.orchestration, that.orchestration) && Objects.equals(this.messageType, that.messageType);
    }

    public int hashCode() {
        return Objects.hash(this.audience, this.notification, this.localizations, this.message, this.deviceTypes, this.pushOptions, this.inApp, this.campaigns, this.globalAttributes, this.orchestration, this.messageType);
    }

    public String toString() {
        return "PushPayload{audience=" + this.audience + ", notification=" + this.notification + ", localizations=" + this.localizations + ", message=" + this.message + ", deviceTypes=" + this.deviceTypes + ", pushOptions=" + this.pushOptions + ", inApp=" + this.inApp + ", campaigns=" + this.campaigns + ", globalAttributes=" + this.globalAttributes + ", orchestration=" + this.orchestration + ", messageType=" + this.messageType + '}';
    }

    public static class Builder {
        private DeviceTypeData deviceTypes = null;
        private Selector audience = null;
        private Notification notification = null;
        private RichPushMessage message = null;
        private PushOptions pushOptions = null;
        private InApp inApp = null;
        private Campaigns campaigns = null;
        private ImmutableList.Builder<Localization> localizationsBuilder = ImmutableList.builder();
        private ImmutableMap.Builder<String, Object> globalAttributesBuilder = ImmutableMap.builder();
        private Orchestration orchestration = null;
        private MessageType messageType = null;

        private Builder() {
        }

        public Builder setAudience(Selector value) {
            this.audience = value;
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setMessage(RichPushMessage message) {
            this.message = message;
            return this;
        }

        public Builder setDeviceTypes(DeviceTypeData deviceTypes) {
            this.deviceTypes = deviceTypes;
            return this;
        }

        public Builder setPushOptions(PushOptions pushOptions) {
            this.pushOptions = pushOptions;
            return this;
        }

        public Builder setInApp(InApp inApp) {
            this.inApp = inApp;
            return this;
        }

        public Builder setCampaigns(Campaigns campaigns) {
            this.campaigns = campaigns;
            return this;
        }

        public Builder addLocalization(Localization localization) {
            this.localizationsBuilder.add((Object)localization);
            return this;
        }

        public Builder addGlobalAttributes(String k, Object o) {
            this.globalAttributesBuilder.put((Object)k, o);
            return this;
        }

        public Builder addAllGlobalAttributes(ImmutableMap<String, Object> globalAttributes) {
            this.globalAttributesBuilder.putAll(globalAttributes);
            return this;
        }

        public Builder setOrchestration(Orchestration orchestration) {
            this.orchestration = orchestration;
            return this;
        }

        public Builder setMessageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public PushPayload build() {
            ImmutableList localizations = this.localizationsBuilder.build();
            ImmutableMap globalAttributes = this.globalAttributesBuilder.build();
            Preconditions.checkArgument((this.notification != null || this.message != null || this.inApp != null ? 1 : 0) != 0, (Object)"At least one of 'notification', 'message', or 'inApp' must be set.");
            Preconditions.checkNotNull((Object)this.audience, (Object)"'audience' must be set");
            Preconditions.checkNotNull((Object)this.deviceTypes, (Object)"'device_types' must be set");
            return new PushPayload(this.audience, Optional.ofNullable(this.notification), Optional.ofNullable(this.message), this.deviceTypes, Optional.ofNullable(this.pushOptions), Optional.ofNullable(this.inApp), Optional.ofNullable(this.campaigns), localizations, globalAttributes, Optional.ofNullable(this.orchestration), Optional.ofNullable(this.messageType));
        }
    }
}

