/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.experiments.model.Variant;
import com.urbanairship.api.experiments.model.VariantPushPayload;
import com.urbanairship.api.schedule.model.Schedule;
import java.io.IOException;

public class VariantReader
implements JsonObjectReader<Variant> {
    private final Variant.Builder builder = Variant.newBuilder();

    public void readName(JsonParser jsonParser) throws IOException {
        this.builder.setName((String)jsonParser.readValueAs(String.class));
    }

    public void readDescription(JsonParser jsonParser) throws IOException {
        this.builder.setDescription((String)jsonParser.readValueAs(String.class));
    }

    public void readSchedule(JsonParser jsonParser) throws IOException {
        this.builder.setSchedule((Schedule)jsonParser.readValueAs(Schedule.class));
    }

    public void readWeight(JsonParser jsonParser) throws IOException {
        this.builder.setWeight((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readVariantPushPayload(JsonParser parser) throws IOException {
        this.builder.setPushPayload((VariantPushPayload)parser.readValueAs(VariantPushPayload.class));
    }

    @Override
    public Variant validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

