/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.experiments.model.Experiment;
import com.urbanairship.api.experiments.model.Variant;
import com.urbanairship.api.push.model.Campaigns;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.Orchestration;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.notification.email.MessageType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;

public class ExperimentReader
implements JsonObjectReader<Experiment> {
    private final Experiment.Builder builder = Experiment.newBuilder();

    public void readName(JsonParser jsonParser) throws IOException {
        this.builder.setName((String)jsonParser.readValueAs(String.class));
    }

    public void readDescription(JsonParser jsonParser) throws IOException {
        this.builder.setDescription((String)jsonParser.readValueAs(String.class));
    }

    public void readControl(JsonParser jsonParser) throws IOException {
        this.builder.setControl((BigDecimal)jsonParser.readValueAs(BigDecimal.class));
    }

    public void readAudience(JsonParser jsonParser) throws IOException {
        this.builder.setAudience((Selector)jsonParser.readValueAs(Selector.class));
    }

    public void readDeviceTypes(JsonParser parser) throws IOException {
        this.builder.setDeviceTypes((DeviceTypeData)parser.readValueAs(DeviceTypeData.class));
    }

    public void readVariants(JsonParser jsonParser) throws IOException {
        this.builder.addAllVariants((List)jsonParser.readValueAs((TypeReference)new TypeReference<List<Variant>>(){}));
    }

    public void readOrchestration(JsonParser parser) throws IOException {
        this.builder.setOrchestration((Orchestration)parser.readValueAs(Orchestration.class));
    }

    public void readMessageType(JsonParser parser) throws IOException {
        this.builder.setMessageType(MessageType.find(StringFieldDeserializer.INSTANCE.deserialize(parser, "message_type")).get());
    }

    public void readCampaigns(JsonParser parser) throws IOException {
        this.builder.setCampaigns((Campaigns)parser.readValueAs(Campaigns.class));
    }

    @Override
    public Experiment validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

