/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.customevents.model;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomEventPropertyValue {
    private final Object value;
    private final Object propertyType;

    public Object getPropertyType() {
        return this.propertyType;
    }

    public static CustomEventPropertyValue of(boolean value) {
        return new CustomEventPropertyValue(value, (Object)PropertyType.BOOLEAN);
    }

    public static CustomEventPropertyValue of(Number value) {
        return new CustomEventPropertyValue(value, (Object)PropertyType.NUMBER);
    }

    public static CustomEventPropertyValue of(String value) {
        return new CustomEventPropertyValue(value, (Object)PropertyType.STRING);
    }

    public static CustomEventPropertyValue of(Iterable<CustomEventPropertyValue> value) {
        return new CustomEventPropertyValue(value, (Object)PropertyType.ITERABLE);
    }

    public static CustomEventPropertyValue of(Map<String, CustomEventPropertyValue> value) {
        return new CustomEventPropertyValue(value, (Object)PropertyType.MAP);
    }

    private CustomEventPropertyValue(Boolean value, Object propertyType) {
        this.value = value;
        this.propertyType = propertyType;
    }

    private CustomEventPropertyValue(Number value, Object propertyType) {
        this.value = value;
        this.propertyType = propertyType;
    }

    private CustomEventPropertyValue(String value, Object propertyType) {
        this.value = value;
        this.propertyType = propertyType;
    }

    private CustomEventPropertyValue(Iterable<CustomEventPropertyValue> value, Object propertyType) {
        this.value = value;
        this.propertyType = propertyType;
    }

    private CustomEventPropertyValue(Map value, Object propertyType) {
        this.value = value;
        this.propertyType = propertyType;
    }

    public boolean isBoolean() {
        return this.propertyType == PropertyType.BOOLEAN;
    }

    public boolean isNumber() {
        return this.propertyType == PropertyType.NUMBER;
    }

    public boolean isString() {
        return this.propertyType == PropertyType.STRING;
    }

    public boolean isArray() {
        return this.propertyType == PropertyType.ITERABLE;
    }

    public boolean isObject() {
        return this.propertyType == PropertyType.MAP;
    }

    public boolean getAsBoolean() {
        if (!this.isBoolean()) {
            throw new IllegalStateException("Unable to convert to Boolean");
        }
        return (Boolean)this.value;
    }

    public Number getAsNumber() {
        if (!this.isNumber()) {
            throw new IllegalStateException("Unable to convert to Number!");
        }
        return (Number)this.value;
    }

    public String getAsString() {
        if (!this.isString()) {
            throw new IllegalStateException("Unable to convert to String!");
        }
        return (String)this.value;
    }

    public List<CustomEventPropertyValue> getAsList() {
        if (!this.isArray()) {
            throw new IllegalStateException("Unable to convert to List!");
        }
        return (List)this.value;
    }

    public Map<String, CustomEventPropertyValue> getAsMap() {
        if (!this.isObject()) {
            throw new IllegalStateException("Unable to convert to Map!");
        }
        return (Map)this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("propertyType", this.propertyType).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomEventPropertyValue propValue = (CustomEventPropertyValue)o;
        return Objects.equals(this.value, propValue.value) && Objects.equals(this.propertyType, propValue.propertyType);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.propertyType);
    }

    private static enum PropertyType {
        BOOLEAN,
        NUMBER,
        STRING,
        ITERABLE,
        MAP;

    }
}

