/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.customevents.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.customevents.model.CustomEventBody;
import com.urbanairship.api.customevents.model.CustomEventUser;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.Optional;
import org.joda.time.DateTime;

public class CustomEventPayload
extends PushModelObject {
    private final Optional<DateTime> occurred;
    private final CustomEventBody customEventBody;
    private final CustomEventUser customEventUser;

    private CustomEventPayload(Builder builder) {
        this.occurred = Optional.ofNullable(builder.occurred);
        this.customEventBody = builder.customEventBody;
        this.customEventUser = builder.customEventUser;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<DateTime> getOccurred() {
        return this.occurred;
    }

    public CustomEventBody getCustomEventBody() {
        return this.customEventBody;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomEventPayload payload = (CustomEventPayload)o;
        return Objects.equal(this.occurred, payload.occurred) && Objects.equal((Object)this.customEventBody, (Object)payload.customEventBody) && Objects.equal((Object)this.customEventUser, (Object)payload.customEventUser);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.occurred, this.customEventBody, this.customEventUser});
    }

    public CustomEventUser getCustomEventUser() {
        return this.customEventUser;
    }

    public static class Builder {
        private DateTime occurred = null;
        private CustomEventBody customEventBody = null;
        private CustomEventUser customEventUser = null;

        public Builder setOccurred(DateTime occurred) {
            this.occurred = occurred;
            return this;
        }

        public Builder setCustomEventBody(CustomEventBody customEventBody) {
            this.customEventBody = customEventBody;
            return this;
        }

        public Builder setCustomEventUser(CustomEventUser customEventUser) {
            this.customEventUser = customEventUser;
            return this;
        }

        public CustomEventPayload build() {
            Preconditions.checkNotNull((Object)this.customEventBody, (Object)"'customEventBody' must not be null");
            Preconditions.checkNotNull((Object)this.customEventUser, (Object)"'customEventUser' must not be null");
            return new CustomEventPayload(this);
        }
    }
}

