/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.createandsend.model.notification.CreateAndSendSchedulePayload;
import com.urbanairship.api.push.model.PushResponse;
import com.urbanairship.api.push.parse.PushObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class CreateAndSendScheduleRequest
implements Request<PushResponse> {
    private static final String API_SCHEDULE_PATH = "/api/schedules/create-and-send";
    private final List<CreateAndSendSchedulePayload> payloads = new ArrayList<CreateAndSendSchedulePayload>();

    private CreateAndSendScheduleRequest(CreateAndSendSchedulePayload payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload required when creating an create and send schedule request");
        this.payloads.add(payload);
    }

    private CreateAndSendScheduleRequest(List<CreateAndSendSchedulePayload> payloadList) {
        Preconditions.checkNotNull(payloadList, (Object)"Payload required when creating a push request");
        if (payloadList.isEmpty()) {
            throw new IllegalStateException("Payload list cannot be empty");
        }
        this.payloads.addAll(payloadList);
    }

    public static CreateAndSendScheduleRequest newRequest(CreateAndSendSchedulePayload payload) {
        return new CreateAndSendScheduleRequest(payload);
    }

    public static CreateAndSendScheduleRequest newRequest(List<CreateAndSendSchedulePayload> payloadList) {
        return new CreateAndSendScheduleRequest(payloadList);
    }

    public CreateAndSendScheduleRequest addPayload(CreateAndSendSchedulePayload newPayload) {
        Preconditions.checkNotNull((Object)newPayload, (Object)"Payload required when adding to a CreateAndSendSchedule request");
        this.payloads.add(newPayload);
        return this;
    }

    public CreateAndSendScheduleRequest addPayloads(List<CreateAndSendSchedulePayload> newPayloads) {
        Preconditions.checkNotNull(newPayloads, (Object)"Payload required when adding to a CreateAndSendSchedule request");
        if (newPayloads.isEmpty()) {
            throw new IllegalStateException("Payload list cannot be empty");
        }
        this.payloads.addAll(newPayloads);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        if (this.payloads.size() == 1) {
            return this.payloads.get(0).toJSON();
        }
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (CreateAndSendSchedulePayload pushPayload : this.payloads) {
            try {
                JsonNode pushJson = mapper.readTree(pushPayload.toJSON());
                arrayNode.add(pushJson);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return arrayNode.toString();
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, API_SCHEDULE_PATH);
    }

    @Override
    public ResponseParser<PushResponse> getResponseParser() {
        return response -> (PushResponse)PushObjectMapper.getInstance().readValue(response, PushResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

