/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.attributes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.channel.model.ChannelModelObject;
import com.urbanairship.api.channel.model.attributes.Attribute;
import com.urbanairship.api.channel.model.attributes.audience.AttributeAudience;

public class ChannelAttributesPayload
extends ChannelModelObject {
    private final AttributeAudience audience;
    ImmutableList<Attribute> attributes;

    private ChannelAttributesPayload(AttributeAudience audience, ImmutableList<Attribute> attributes) {
        this.audience = audience;
        this.attributes = attributes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public AttributeAudience getAudience() {
        return this.audience;
    }

    public ImmutableList<Attribute> getAttributes() {
        return this.attributes;
    }

    public static class Builder {
        AttributeAudience audience;
        ImmutableList.Builder<Attribute> attributesBuilder = ImmutableList.builder();

        public Builder setAudience(AttributeAudience audience) {
            this.audience = audience;
            return this;
        }

        public Builder addAttribute(Attribute attribute) {
            this.attributesBuilder.add((Object)attribute);
            return this;
        }

        public ChannelAttributesPayload build() {
            ImmutableList attributes = this.attributesBuilder.build();
            Preconditions.checkNotNull((Object)this.audience, (Object)"Audience must be set.");
            Preconditions.checkArgument((attributes.size() > 0 ? 1 : 0) != 0, (Object)"Attributes must be added to ChannelAttributesPayload.");
            return new ChannelAttributesPayload(this.audience, attributes);
        }
    }
}

