/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.attributes;

import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.attributes.AttributeAction;
import com.urbanairship.api.common.parse.DateFormats;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class Attribute {
    private final AttributeAction action;
    private final String key;
    private final Optional<String> value;
    private final Optional<DateTime> timeStamp;

    private Attribute(Builder builder) {
        this.action = builder.action;
        this.key = builder.key;
        this.value = Optional.ofNullable(builder.value);
        this.timeStamp = Optional.ofNullable(builder.timeStamp);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public AttributeAction getAction() {
        return this.action;
    }

    public String getKey() {
        return this.key;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public Optional<DateTime> getTimeStamp() {
        return this.timeStamp;
    }

    public static class Builder {
        AttributeAction action;
        String key;
        String value;
        DateTime timeStamp;

        public Builder setAction(AttributeAction action) {
            this.action = action;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setTimeStamp(DateTime timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setValue(DateTime value) {
            this.value = DateFormats.DATE_FORMATTER.print((ReadableInstant)value);
            return this;
        }

        public Builder setValue(Integer value) {
            this.value = value.toString();
            return this;
        }

        public Attribute build() {
            Preconditions.checkNotNull((Object)((Object)this.action), (Object)"Attribute action must be set.");
            Preconditions.checkNotNull((Object)this.key, (Object)"key must be set.");
            if (this.action.equals((Object)AttributeAction.SET)) {
                Preconditions.checkNotNull((Object)this.value, (Object)"Value must not be null when setting attributes");
            }
            return new Attribute(this);
        }
    }
}

