/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.channel.model.ChannelModelObject;
import com.urbanairship.api.channel.model.ChannelUninstallDevice;
import java.util.Set;

public class ChannelUninstallPayload
extends ChannelModelObject {
    private final Set<ChannelUninstallDevice> channels;

    private ChannelUninstallPayload(Set<ChannelUninstallDevice> channels) {
        this.channels = channels;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Set<ChannelUninstallDevice> getChannels() {
        return this.channels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelUninstallPayload that = (ChannelUninstallPayload)o;
        return Objects.equal(this.channels, that.channels);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.channels});
    }

    public String toString() {
        return "ChannelUninstallDevice{channels=" + this.channels + '}';
    }

    public static class Builder {
        ImmutableSet.Builder<ChannelUninstallDevice> channelsBuilder = ImmutableSet.builder();

        public Builder setChannels(Set<ChannelUninstallDevice> channels) {
            this.channelsBuilder.addAll(channels);
            return this;
        }

        public ChannelUninstallPayload build() {
            ImmutableSet channels = this.channelsBuilder.build();
            Preconditions.checkArgument((channels.size() > 0 ? 1 : 0) != 0, (Object)"At least one channel must be set.");
            Preconditions.checkArgument((channels.size() <= 1000 ? 1 : 0) != 0, (Object)"Maximum of 1000 channels per payload.");
            return new ChannelUninstallPayload((Set)channels);
        }
    }
}

