/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel;

import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.OpenChannelResponse;
import com.urbanairship.api.channel.model.open.OpenChannelPayload;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class OpenChannelRequest
implements Request<OpenChannelResponse> {
    private static final String API_OPEN_CHANNEL = "/api/channels/open/";
    private final OpenChannelPayload payload;

    private OpenChannelRequest(OpenChannelPayload payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload must not be null to create an open channel request");
        this.payload = payload;
    }

    public static OpenChannelRequest newRequest(OpenChannelPayload payload) {
        return new OpenChannelRequest(payload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        return this.payload.toJSON();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, API_OPEN_CHANNEL);
    }

    @Override
    public ResponseParser<OpenChannelResponse> getResponseParser() {
        return response -> (OpenChannelResponse)ChannelObjectMapper.getInstance().readValue(response, OpenChannelResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

