/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.attributelists.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.attributelists.model.AttributeListsView;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import java.io.IOException;
import java.util.Map;
import org.joda.time.DateTime;

public class AttributeListsViewReader
implements JsonObjectReader<AttributeListsView> {
    private final AttributeListsView.Builder builder = AttributeListsView.newBuilder();

    public void readOk(JsonParser jsonParser) throws IOException {
        this.builder.setOk((Boolean)jsonParser.readValueAs(Boolean.class));
    }

    public void readName(JsonParser jsonParser) throws IOException {
        this.builder.setName((String)jsonParser.readValueAs(String.class));
    }

    public void readDescription(JsonParser jsonParser) throws IOException {
        this.builder.setDescription((String)jsonParser.readValueAs(String.class));
    }

    public void readExtras(JsonParser jsonParser) throws IOException {
        Map mutableExtras = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
        ImmutableMap<String, String> extras = AttributeListsViewReader.immutableMapConverter(mutableExtras);
        this.builder.addAllExtras(extras);
    }

    public void readCreated(JsonParser jsonParser) throws IOException {
        this.builder.setCreated((DateTime)jsonParser.readValueAs(DateTime.class));
    }

    public void readLastUpdated(JsonParser jsonParser) throws IOException {
        this.builder.setLastUpdated((DateTime)jsonParser.readValueAs(DateTime.class));
    }

    public void readChannelCount(JsonParser jsonParser) throws IOException {
        this.builder.setChannelCount((Integer)jsonParser.readValueAs(Integer.TYPE));
    }

    public void readErrorPath(JsonParser jsonParser) throws IOException {
        this.builder.setErrorPath((String)jsonParser.readValueAs(String.class));
    }

    public void readStatus(JsonParser jsonParser) throws IOException {
        this.builder.setStatus((String)jsonParser.readValueAs(String.class));
    }

    @Override
    public AttributeListsView validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }

    private static ImmutableMap<String, String> immutableMapConverter(Map<String, String> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return builder.build();
    }
}

