/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.interceptor;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeaderAuthorizationInterceptor
implements Interceptor {
    private List<String> apiKey;
    private Map<String, Boolean> apiKeyMap;

    public HeaderAuthorizationInterceptor(List<String> apiKey) {
        this.apiKey = apiKey;
        this.apiKeyMap = apiKey.stream().collect(Collectors.toMap(Function.identity(), s -> true));
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request request = original.newBuilder().header(Header.AUTHORIZATION.getValue(), "Bearer " + (String)RandomUtil.randomEle(this.apiKey)).header(Header.CONTENT_TYPE.getValue(), ContentType.JSON.getValue()).method(original.method(), original.body()).build();
        return chain.proceed(request);
    }

    public List<String> getApiKey() {
        return this.apiKey;
    }

    public Map<String, Boolean> getApiKeyMap() {
        return this.apiKeyMap;
    }
}

