/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.embeddings;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import java.io.Serializable;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Embedding
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Embedding.class);
    @NonNull
    private String model;
    @NonNull
    private String input;
    private String user;

    public void setModel(Model model) {
        if (Objects.isNull((Object)model)) {
            model = Model.TEXT_EMBEDDING_ADA_002;
        }
        this.model = model.getName();
    }

    public void setInput(String input) {
        if (input == null || "".equals(input)) {
            log.error("input\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (input.length() > 8192) {
            log.error("input\u8d85\u957f");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        this.input = input;
    }

    public void setUser(String user) {
        this.user = user;
    }

    private static String $default$model() {
        return Model.TEXT_EMBEDDING_ADA_002.getName();
    }

    public static EmbeddingBuilder builder() {
        return new EmbeddingBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getInput() {
        return this.input;
    }

    public String getUser() {
        return this.user;
    }

    public Embedding() {
        this.model = Embedding.$default$model();
    }

    public Embedding(@NonNull String model, @NonNull String input, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.model = model;
        this.input = input;
        this.user = user;
    }

    public static class EmbeddingBuilder {
        private boolean model$set;
        private String model$value;
        private String input;
        private String user;

        EmbeddingBuilder() {
        }

        public EmbeddingBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public EmbeddingBuilder input(@NonNull String input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public EmbeddingBuilder user(String user) {
            this.user = user;
            return this;
        }

        public Embedding build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = Embedding.$default$model();
            }
            return new Embedding(model$value, this.input, this.user);
        }

        public String toString() {
            return "Embedding.EmbeddingBuilder(model$value=" + this.model$value + ", input=" + this.input + ", user=" + this.user + ")";
        }
    }

    public static enum Model {
        TEXT_EMBEDDING_ADA_002("text-embedding-ada-002");

        private String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

