/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.messages.SortOrder;
import com.unboundid.scim2.server.ListResponseStreamingOutput;
import com.unboundid.scim2.server.ListResponseWriter;
import com.unboundid.scim2.server.utils.ResourceComparator;
import com.unboundid.scim2.server.utils.ResourcePreparer;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SchemaAwareFilterEvaluator;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SimpleSearchResults<T extends ScimResource>
extends ListResponseStreamingOutput<T> {
    @NotNull
    private final List<ScimResource> resources;
    @NotNull
    private final Filter filter;
    @Nullable
    private final Integer startIndex;
    @Nullable
    private final Integer count;
    @NotNull
    private final SchemaAwareFilterEvaluator filterEvaluator;
    @Nullable
    private final ResourceComparator<ScimResource> resourceComparator;
    @NotNull
    private final ResourcePreparer<ScimResource> responsePreparer;

    public SimpleSearchResults(@NotNull ResourceTypeDefinition resourceType, @NotNull UriInfo uriInfo) throws BadRequestException {
        Path sortBy;
        int i;
        this.filterEvaluator = new SchemaAwareFilterEvaluator(resourceType);
        this.responsePreparer = new ResourcePreparer(resourceType, uriInfo);
        this.resources = new LinkedList<ScimResource>();
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        String filterString = (String)queryParams.getFirst((Object)"filter");
        String startIndexString = (String)queryParams.getFirst((Object)"startIndex");
        String countString = (String)queryParams.getFirst((Object)"count");
        String sortByString = (String)queryParams.getFirst((Object)"sortBy");
        String sortOrderString = (String)queryParams.getFirst((Object)"sortOrder");
        this.filter = filterString != null ? Filter.fromString((String)filterString) : null;
        this.startIndex = startIndexString != null ? Integer.valueOf((i = Integer.valueOf(startIndexString).intValue()) < 1 ? 1 : i) : null;
        this.count = countString != null ? Integer.valueOf((i = Integer.valueOf(countString).intValue()) < 0 ? 0 : i) : null;
        try {
            sortBy = sortByString == null ? null : Path.fromString((String)sortByString);
        }
        catch (BadRequestException e) {
            throw BadRequestException.invalidValue((String)("'" + sortByString + "' is not a valid value for the sortBy parameter: " + e.getMessage()));
        }
        SortOrder sortOrder = sortOrderString == null ? SortOrder.ASCENDING : SortOrder.fromName((String)sortOrderString);
        this.resourceComparator = sortBy != null ? new ResourceComparator(sortBy, sortOrder, resourceType) : null;
    }

    @NotNull
    public SimpleSearchResults add(@NotNull T resource) throws ScimException {
        GenericScimResource genericResource = resource instanceof GenericScimResource ? new GenericScimResource(((GenericScimResource)resource).getObjectNode().deepCopy()) : resource.asGenericScimResource();
        this.responsePreparer.setResourceTypeAndLocation((ScimResource)genericResource);
        if (this.filter == null || ((Boolean)this.filter.visit((FilterVisitor)this.filterEvaluator, (Object)genericResource.getObjectNode())).booleanValue()) {
            this.resources.add((ScimResource)genericResource);
        }
        return this;
    }

    @NotNull
    public SimpleSearchResults addAll(@NotNull Collection<T> resources) throws ScimException {
        for (ScimResource resource : resources) {
            this.add(resource);
        }
        return this;
    }

    @Override
    public void write(@NotNull ListResponseWriter<T> os) throws IOException {
        if (this.resourceComparator != null) {
            Collections.sort(this.resources, this.resourceComparator);
        }
        List<Object> resultsToReturn = this.resources;
        if (this.startIndex != null) {
            resultsToReturn = this.startIndex > this.resources.size() ? Collections.emptyList() : this.resources.subList(this.startIndex - 1, this.resources.size());
        }
        if (this.count != null && !resultsToReturn.isEmpty()) {
            resultsToReturn = resultsToReturn.subList(0, Math.min(this.count, resultsToReturn.size()));
        }
        os.totalResults(this.resources.size());
        if (this.startIndex != null || this.count != null) {
            os.startIndex(this.startIndex == null ? 1 : this.startIndex);
            os.itemsPerPage(resultsToReturn.size());
        }
        for (ScimResource scimResource : resultsToReturn) {
            os.resource(this.responsePreparer.trimRetrievedResource(scimResource));
        }
    }
}

