/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.server.utils.ResourceTrimmer;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import java.util.Set;

public class ScimResourceTrimmer
extends ResourceTrimmer {
    @NotNull
    private final ResourceTypeDefinition resourceType;
    @NotNull
    private final Set<Path> requestAttributes;
    @NotNull
    private final Set<Path> queryAttributes;
    private final boolean excluded;

    public ScimResourceTrimmer(@NotNull ResourceTypeDefinition resourceType, @NotNull Set<Path> requestAttributes, @NotNull Set<Path> queryAttributes, boolean excluded) {
        this.resourceType = resourceType;
        this.requestAttributes = requestAttributes;
        this.queryAttributes = queryAttributes;
        this.excluded = excluded;
    }

    @Override
    public boolean shouldReturn(@NotNull Path path) {
        AttributeDefinition attributeDefinition = this.resourceType.getAttributeDefinition(path);
        AttributeDefinition.Returned returned = attributeDefinition == null ? AttributeDefinition.Returned.DEFAULT : attributeDefinition.getReturned();
        switch (returned) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case REQUEST: {
                return this.pathContains(this.requestAttributes, path) || this.requestAttributes.isEmpty() && !this.excluded && this.pathContains(this.queryAttributes, path);
            }
        }
        if (this.excluded) {
            return !this.pathContains(this.queryAttributes, path);
        }
        return this.queryAttributes.isEmpty() || this.pathContains(this.queryAttributes, path);
    }

    private boolean pathContains(@NotNull Set<Path> paths, @NotNull Path path) {
        if (paths.contains(path)) {
            return true;
        }
        if (!this.excluded) {
            for (Path p : paths) {
                if (p.size() <= path.size() || !path.equals((Object)p.subPath(path.size()))) continue;
                return true;
            }
        }
        Path p = path;
        while (p.size() > 0) {
            if (paths.contains(p)) {
                return true;
            }
            p = p.subPath(p.size() - 1);
        }
        return false;
    }
}

