/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.resources;

import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ForbiddenException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.types.ResourceTypeResource;
import com.unboundid.scim2.server.annotations.ResourceType;
import com.unboundid.scim2.server.utils.ResourcePreparer;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SchemaAwareFilterEvaluator;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

@ResourceType(description="SCIM 2.0 Resource Type", name="ResourceType", schema=ResourceTypeResource.class, discoverable=false)
@Path(value="ResourceTypes")
public class ResourceTypesEndpoint {
    @NotNull
    private static final ResourceTypeDefinition RESOURCE_TYPE_DEFINITION = ResourceTypeDefinition.fromJaxRsResource(ResourceTypesEndpoint.class);
    @NotNull
    @Context
    private Application application;

    @GET
    @Produces(value={"application/scim+json", "application/json"})
    @NotNull
    public ListResponse<GenericScimResource> search(@Nullable @QueryParam(value="filter") String filterString, @NotNull @Context UriInfo uriInfo) throws ScimException {
        if (filterString != null) {
            throw new ForbiddenException("Filtering not allowed");
        }
        ResourcePreparer<GenericScimResource> preparer = new ResourcePreparer<GenericScimResource>(RESOURCE_TYPE_DEFINITION, uriInfo);
        Collection<ResourceTypeResource> resourceTypes = this.getResourceTypes();
        ArrayList<GenericScimResource> preparedResources = new ArrayList<GenericScimResource>(resourceTypes.size());
        for (ResourceTypeResource resourceType : resourceTypes) {
            GenericScimResource preparedResource = resourceType.asGenericScimResource();
            preparer.setResourceTypeAndLocation(preparedResource);
            preparedResources.add(preparedResource);
        }
        return new ListResponse(preparedResources);
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/scim+json", "application/json"})
    @NotNull
    public ScimResource get(@NotNull @PathParam(value="id") String id, @NotNull @Context UriInfo uriInfo) throws ScimException {
        Filter filter = Filter.or((Filter)Filter.eq((String)"id", (String)id), (Filter)Filter.eq((String)"name", (String)id), (Filter[])new Filter[0]);
        SchemaAwareFilterEvaluator filterEvaluator = new SchemaAwareFilterEvaluator(RESOURCE_TYPE_DEFINITION);
        ResourcePreparer<GenericScimResource> resourcePreparer = new ResourcePreparer<GenericScimResource>(RESOURCE_TYPE_DEFINITION, uriInfo);
        for (ResourceTypeResource resourceType : this.getResourceTypes()) {
            GenericScimResource resource = resourceType.asGenericScimResource();
            if (!((Boolean)filter.visit((FilterVisitor)filterEvaluator, (Object)resource.getObjectNode())).booleanValue()) continue;
            resourcePreparer.setResourceTypeAndLocation(resource);
            return resource;
        }
        throw new ResourceNotFoundException("No resource type defined with ID or name " + id);
    }

    @NotNull
    public Collection<ResourceTypeResource> getResourceTypes() throws ScimException {
        ResourceTypeDefinition resourceTypeDefinition;
        HashSet<ResourceTypeResource> resourceTypes = new HashSet<ResourceTypeResource>();
        for (Class resourceClass : this.application.getClasses()) {
            resourceTypeDefinition = ResourceTypeDefinition.fromJaxRsResource(resourceClass);
            if (resourceTypeDefinition == null || !resourceTypeDefinition.isDiscoverable()) continue;
            resourceTypes.add(resourceTypeDefinition.toScimResource());
        }
        for (Object resourceInstance : this.application.getSingletons()) {
            resourceTypeDefinition = ResourceTypeDefinition.fromJaxRsResource(resourceInstance.getClass());
            if (resourceTypeDefinition == null || !resourceTypeDefinition.isDiscoverable()) continue;
            resourceTypes.add(resourceTypeDefinition.toScimResource());
        }
        return resourceTypes;
    }
}

