/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.utils.CalendarDeserializer;
import com.unboundid.scim2.common.utils.CalendarSerializer;
import com.unboundid.scim2.common.utils.DateDeserializer;
import com.unboundid.scim2.common.utils.DateSerializer;
import com.unboundid.scim2.common.utils.ScimJsonFactory;
import com.unboundid.scim2.common.utils.ScimJsonNodeFactory;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class MapperFactory {
    @NotNull
    private Map<DeserializationFeature, Boolean> deserializationCustomFeatures = Collections.emptyMap();
    @NotNull
    private Map<JsonParser.Feature, Boolean> jsonParserCustomFeatures = Collections.emptyMap();
    @NotNull
    private Map<JsonGenerator.Feature, Boolean> jsonGeneratorCustomFeatures = Collections.emptyMap();
    @NotNull
    private Map<MapperFeature, Boolean> mapperCustomFeatures = Collections.emptyMap();
    @NotNull
    private Map<SerializationFeature, Boolean> serializationCustomFeatures = Collections.emptyMap();

    @NotNull
    public MapperFactory setDeserializationCustomFeatures(@NotNull Map<DeserializationFeature, Boolean> customFeatures) {
        this.deserializationCustomFeatures = customFeatures;
        return this;
    }

    @NotNull
    public MapperFactory setJsonGeneratorCustomFeatures(@NotNull Map<JsonGenerator.Feature, Boolean> customFeatures) {
        this.jsonGeneratorCustomFeatures = customFeatures;
        return this;
    }

    @NotNull
    public MapperFactory setJsonParserCustomFeatures(@NotNull Map<JsonParser.Feature, Boolean> customFeatures) {
        this.jsonParserCustomFeatures = customFeatures;
        return this;
    }

    @NotNull
    public MapperFactory setMapperCustomFeatures(@NotNull Map<MapperFeature, Boolean> customFeatures) {
        this.mapperCustomFeatures = customFeatures;
        return this;
    }

    @NotNull
    public MapperFactory setSerializationCustomFeatures(@NotNull Map<SerializationFeature, Boolean> customFeatures) {
        this.serializationCustomFeatures = customFeatures;
        return this;
    }

    @NotNull
    public ObjectMapper createObjectMapper() {
        JsonMapper.Builder objectMapperBuilder = JsonMapper.builder((JsonFactory)new ScimJsonFactory());
        objectMapperBuilder.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES});
        this.mapperCustomFeatures.forEach((arg_0, arg_1) -> ((JsonMapper.Builder)objectMapperBuilder).configure(arg_0, arg_1));
        ObjectMapper mapper = objectMapperBuilder.build();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleModule dateTimeModule = new SimpleModule();
        dateTimeModule.addSerializer(Calendar.class, (JsonSerializer)new CalendarSerializer());
        dateTimeModule.addDeserializer(Calendar.class, (JsonDeserializer)new CalendarDeserializer());
        dateTimeModule.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        dateTimeModule.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        mapper.registerModule((Module)dateTimeModule);
        mapper.setNodeFactory((JsonNodeFactory)new ScimJsonNodeFactory());
        this.deserializationCustomFeatures.forEach((arg_0, arg_1) -> ((ObjectMapper)mapper).configure(arg_0, arg_1));
        this.jsonGeneratorCustomFeatures.forEach((arg_0, arg_1) -> ((ObjectMapper)mapper).configure(arg_0, arg_1));
        this.jsonParserCustomFeatures.forEach((arg_0, arg_1) -> ((ObjectMapper)mapper).configure(arg_0, arg_1));
        this.serializationCustomFeatures.forEach((arg_0, arg_1) -> ((ObjectMapper)mapper).configure(arg_0, arg_1));
        return mapper;
    }
}

