/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.unboundid.scim2.common.annotations.NotNull;
import jakarta.xml.bind.DatatypeConverter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DateTimeUtils {
    @NotNull
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");

    @NotNull
    public static String format(@NotNull Date date) {
        return DateTimeUtils.format(date, DEFAULT_TIME_ZONE);
    }

    @NotNull
    public static String format(@NotNull Date date, @NotNull TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return DateTimeUtils.format(calendar);
    }

    @NotNull
    public static String format(@NotNull Calendar calendar) {
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    @NotNull
    public static Calendar parse(@NotNull String dateStr) throws IllegalArgumentException {
        return DatatypeConverter.parseDateTime((String)dateStr);
    }
}

